/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to be used on class level to specify the event which matches the interface of a
 * deviated {@link EventContext}.
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface EventName {

  /**
   * Returns the name of the event the typed {@link EventContext} provides its interface for.
   *
   * @return the name of the event a typed {@link EventContext} is attached to
   */
  String value();
}
