/*
 * © 2020-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.application;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

@EventName(ApplicationLifecycleService.EVENT_APPLICATION_PREPARED)
public interface ApplicationPreparedEventContext extends EventContext {

  /**
   * Creates an {@link EventContext} already overlaid with this interface. The event is set to be
   * {@link ApplicationLifecycleService#EVENT_APPLICATION_PREPARED}
   *
   * @return the {@link ApplicationPreparedEventContext}
   */
  static ApplicationPreparedEventContext create() {
    return EventContext.create(ApplicationPreparedEventContext.class, null);
  }

  @Override
  ApplicationLifecycleService getService();
}
