/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.auditlog;

/** Constants of supported data modification and configuration change actions. */
public enum Action {
  /** An attribute is created. */
  CREATE("Create"),

  /** An attribute is updated. */
  UPDATE("Update"),

  /** An attribute is deleted. */
  DELETE("Delete");

  private final String name;

  private Action(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return this.name;
  }
}
