/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.auditlog;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;
import java.util.Collection;

@CdsName("com.sap.cds.services.auditlog.ConfigChange")
public interface ConfigChange extends CdsData {
  String OBJECT = "object";

  String ATTRIBUTES = "attributes";

  /**
   * The object where the accessed or modified personal data that is being audit logged is
   * contained.
   */
  DataObject getDataObject();

  /**
   * The object where the accessed or modified personal data that is being audit logged is
   * contained.
   */
  void setDataObject(DataObject object);

  Collection<ChangedAttribute> getAttributes();

  void setAttributes(Collection<ChangedAttribute> attributes);

  static ConfigChange create() {
    return Struct.create(ConfigChange.class);
  }
}
