/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.auditlog;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;
import java.util.Collection;

/**
 * Data access interface for logging successful and unsuccessful access to any sensitive personal
 * data.
 */
@CdsName("com.sap.cds.services.auditlog.dataAccessLog")
public interface DataAccessLog extends CdsData {
  String ACCESSES = "accesses";

  String ACCESS_FILTERS = "accessFilters";

  /** All data accesses to log. */
  Collection<Access> getAccesses();

  /** All data accesses to log. */
  void setAccesses(Collection<Access> accesses);

  static DataAccessLog create() {
    return Struct.create(DataAccessLog.class);
  }
}
