/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.messaging;

import com.sap.cds.services.Service;
import java.util.Map;

/** Messaging service. */
public interface MessagingService extends Service {

  /** The name of the composite {@link MessagingService} */
  public static final String COMPOSITE_NAME = "MessagingService$Composite";

  /**
   * The messaging error event, that allows to handle acknowledgement of a message on the messaging
   * channel
   */
  public static final String EVENT_MESSAGING_ERROR = "MESSAGING_ERROR";

  /**
   * The message Map is interpreted as data map and passed to {@link #emit(String, Map, Map)}.
   * Usually this results in a final message like: {data: message}
   *
   * @param topic the topic
   * @param message the Map to be serialized to JSON and then sent
   */
  public void emit(String topic, Map<String, Object> message);

  /**
   * Takes a (cloudevents) message, separated into data and headers and sends it to the specified
   * topic of this message broker.
   *
   * <p>Usually data and headers are combined into a final JSON string message following the rule:
   * {...headers, data: data}. Brokers (e.g. Kafka) that natively support headers might separate
   * headers from data
   *
   * @param topic the topic
   * @param data the data Map
   * @param headers the headers Map
   */
  public void emit(String topic, Map<String, Object> data, Map<String, Object> headers);
}
