/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import java.util.List;
import java.util.Map;

@EventName(DeploymentService.EVENT_DEPENDENCIES)
public interface DependenciesEventContext extends EventContext {

  /**
   * Creates an {@link EventContext} already overlaid with this interface. The event is set to be
   * {@link DeploymentService#EVENT_DEPENDENCIES}
   *
   * @return the {@link DependenciesEventContext}
   */
  static DependenciesEventContext create() {
    return EventContext.create(DependenciesEventContext.class, null);
  }

  @Override
  DeploymentService getService();

  /**
   * Returns a list of dependencies required by this application. When reporting dependencies to
   * SaaS Registry consider wrapping the {@link Map} with {@code SaasRegistryDependency}, as a
   * type-safe alternative.
   *
   * @return the list of required dependencies
   */
  List<Map<String, Object>> getResult();

  /**
   * Returns a list of dependencies required by this application. When reporting dependencies to
   * SaaS Registry consider wrapping the {@link Map} with {@code SaasRegistryDependency}, as a
   * type-safe alternative.
   *
   * @param dependencies the list of required dependencies
   */
  void setResult(List<? extends Map<String, Object>> dependencies);
}
