/*
 * © 2020-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.runtime;

import com.sap.cds.services.authentication.AuthenticationInfo;

/**
 * A {@link AuthenticationInfoProvider} provides the {@link AuthenticationInfo} of the request. This
 * is usually interpreted by a {@link UserInfoProvider} to extract the user information from the
 * authentication. The {@link AuthenticationInfo} might be used directly to implement principal
 * propagation of the raw authentication context.
 */
public interface AuthenticationInfoProvider extends CdsProvider<AuthenticationInfoProvider> {

  /**
   * Provides the {@link AuthenticationInfo}.
   *
   * @return the {@link AuthenticationInfo} if available, {@code null} otherwise.
   */
  AuthenticationInfo get();
}
