/*
 * © 2020-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.runtime;

import com.sap.cds.services.Service;

public interface CdsRuntimeConfiguration {

  /**
   * The order can be used to execute configurations in a specified order. The default order is 0.
   * Configurations with a lower order are executed before configurations with a higher order.
   *
   * <p>When registering custom configurations it is recommended to either use order values around
   * either {@link Integer#MIN_VALUE} or {@link Integer#MAX_VALUE} to execute configurations either
   * before or after the built-in configurations.
   *
   * @return the order value
   */
  default int order() {
    return 0;
  }

  /**
   * Creates and registers one or multiple environment provider instances, using the given {@link
   * CdsRuntimeConfigurer}
   *
   * @param configurer the {@link CdsRuntimeConfigurer}
   */
  default void environment(CdsRuntimeConfigurer configurer) {}

  /**
   * Creates and registers one or multiple {@link Service} instances, using the given {@link
   * CdsRuntimeConfigurer}
   *
   * @param configurer the {@link CdsRuntimeConfigurer}
   */
  default void services(CdsRuntimeConfigurer configurer) {}

  /**
   * Creates and registers one or multiple event handler instances, using the given {@link
   * CdsRuntimeConfigurer}
   *
   * @param configurer the {@link CdsRuntimeConfigurer}
   */
  default void eventHandlers(CdsRuntimeConfigurer configurer) {}

  /**
   * Creates and registers one or multiple provider instances, using the given {@link
   * CdsRuntimeConfigurer}
   *
   * @param configurer the {@link CdsRuntimeConfigurer}
   */
  default void providers(CdsRuntimeConfigurer configurer) {}
}
