/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.auditlog;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;
import java.util.Collection;

/**
 * Data modification interface for logging successful and unsuccessful modification to any sensitive
 * personal data.
 */
@CdsName("com.sap.cds.services.auditlog.dataModificationLog")
public interface DataModificationLog extends CdsData {
  String MODIFICATIONS = "modifications";

  /** All modifications to log. */
  Collection<DataModification> getModifications();

  /** All modifications to log. */
  void setModifications(Collection<DataModification> modifications);

  static DataModificationLog create() {
    return Struct.create(DataModificationLog.class);
  }
}
