/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.authentication;

/**
 * Representation of a {@link JwtTokenAuthenticationInfo} which additionally provides a forward
 * token. WARNING: In general, the forward token is NOT authenticated and is meant for forwarding to
 * remote services only.
 *
 * <p>For instance, in hybrid IAS/XSUAA authentication mode, the initial ID token can be used to
 * forward to remote IAS-based services.
 */
public class JwtTokenWithForwardJwtAuthenticationInfo extends JwtTokenAuthenticationInfo {

  private final String forwardToken;

  public JwtTokenWithForwardJwtAuthenticationInfo(String requestToken, String forwardToken) {
    super(requestToken);
    this.forwardToken = forwardToken;
  }

  /**
   * @return the additional OAuth2 JWT token
   */
  public String getForwardToken() {
    return forwardToken;
  }
}
