/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.authorization;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

@EventName(AuthorizationService.EVENT_CALC_WHERE_CONDITION)
public interface CalcWhereConditionEventContext extends EventContext {

  static CalcWhereConditionEventContext create(String entityName) {
    return EventContext.create(CalcWhereConditionEventContext.class, entityName);
  }

  @Override
  AuthorizationService getService();

  // IN
  void setEntityName(String entity);

  String getEntityName();

  void setEventName(String event);

  String getEventName();

  // OUT
  CqnPredicate getResult();

  void setResult(CqnPredicate result);
}
