/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.datasource;

import javax.sql.DataSource;

/** The descriptor of {@link DataSource} objects */
public interface DataSourceDescriptor {

  /**
   * @return the name of the data source
   */
  String getName();

  /**
   * @return the driver class name
   */
  String getDriverClassName();

  /**
   * @return the JDBC url
   */
  String getUrl();

  /**
   * @return the JDBC username
   */
  String getUsername();

  /**
   * @return the JDBC password
   */
  String getPassword();

  /**
   * @return the credential type. Might be `null`. Only available for HANA
   */
  default String getCredentialType() {
    return null;
  }
}
