/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.datasource;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import java.util.Map;
import javax.sql.DataSource;

/**
 * Interface for classes that create {@link DataSource} objects. Implementing classes can get access
 * to the {@link CdsRuntime} by implementing {@link CdsRuntimeAware}.
 */
public interface DataSourceFactory {

  /**
   * A map containing all created {@link DataSource} objects. The key in the map is the name
   * assigned to the {@link DataSource}
   *
   * @return the map of {@link DataSource} objects
   */
  Map<String, DataSource> create();
}
