/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.draft;

import com.sap.cds.CdsData;
import com.sap.cds.ql.CdsName;
import java.time.Instant;

/** Interface for the DraftAdministrativeData of a draft enabled entity. */
public interface DraftAdministrativeData extends CdsData {

  String ENTITY_NAME = "DraftAdministrativeData";

  String CDS_NAME = "DRAFT.DraftAdministrativeData";

  String DRAFT_IS_CREATED_BY_ME = "DraftIsCreatedByMe";

  String CREATION_DATE_TIME = "CreationDateTime";

  String DRAFT_UUID = "DraftUUID";

  String CREATED_BY_USER = "CreatedByUser";

  String LAST_CHANGE_DATE_TIME = "LastChangeDateTime";

  String DRAFT_IS_PROCESSED_BY_ME = "DraftIsProcessedByMe";

  String IN_PROCESS_BY_USER = "InProcessByUser";

  String LAST_CHANGED_BY_USER = "LastChangedByUser";

  @CdsName(DRAFT_IS_CREATED_BY_ME)
  Boolean getDraftIsCreatedByMe();

  @CdsName(DRAFT_IS_CREATED_BY_ME)
  void setDraftIsCreatedByMe(Boolean draftIsCreatedByMe);

  @CdsName(CREATION_DATE_TIME)
  Instant getCreationDateTime();

  @CdsName(CREATION_DATE_TIME)
  void setCreationDateTime(Instant creationDateTime);

  @CdsName(DRAFT_UUID)
  String getDraftUUID();

  @CdsName(DRAFT_UUID)
  void setDraftUUID(String draftUUID);

  @CdsName(CREATED_BY_USER)
  String getCreatedByUser();

  @CdsName(CREATED_BY_USER)
  void setCreatedByUser(String createdByUser);

  @CdsName(LAST_CHANGE_DATE_TIME)
  Instant getLastChangeDateTime();

  @CdsName(LAST_CHANGE_DATE_TIME)
  void setLastChangeDateTime(Instant lastChangeDateTime);

  @CdsName(DRAFT_IS_PROCESSED_BY_ME)
  Boolean getDraftIsProcessedByMe();

  @CdsName(DRAFT_IS_PROCESSED_BY_ME)
  void setDraftIsProcessedByMe(Boolean draftIsProcessedByMe);

  @CdsName(IN_PROCESS_BY_USER)
  String getInProcessByUser();

  @CdsName(IN_PROCESS_BY_USER)
  void setInProcessByUser(String inProcessByUser);

  @CdsName(LAST_CHANGED_BY_USER)
  String getLastChangedByUser();

  @CdsName(LAST_CHANGED_BY_USER)
  void setLastChangedByUser(String lastChangedByUser);
}
