/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.environment;

import com.sap.cds.services.runtime.CdsProvider;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.stream.Stream;

/** Provider for available {@link ServiceBinding}s */
public interface ServiceBindingProvider extends CdsProvider<ServiceBindingProvider> {

  /**
   * Provides the available {@link ServiceBinding}s.
   *
   * @return a stream of all available {@link ServiceBinding}s.
   */
  Stream<ServiceBinding> get();
}
