/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import java.util.List;
import java.util.Map;

@EventName(DeploymentService.EVENT_UPGRADE)
public interface UpgradeEventContext extends EventContext {

  /**
   * Creates an {@link EventContext} already overlaid with this interface. The event is set to be
   * {@link DeploymentService#EVENT_UPGRADE}
   *
   * @return the {@link UpgradeEventContext}
   */
  static UpgradeEventContext create() {
    return EventContext.create(UpgradeEventContext.class, null);
  }

  @Override
  DeploymentService getService();

  /**
   * @return the tenant IDs
   */
  List<String> getTenants();

  /**
   * Sets the tenant IDs
   *
   * @param tenants the tenant IDs
   */
  void setTenants(List<String> tenants);

  /**
   * @return the optional additional options
   */
  Map<String, Object> getOptions();

  /**
   * Sets the optional additional options
   *
   * @param options the optional additional options
   */
  void setOptions(Map<String, Object> options);
}
