/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.auditlog.event;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cds.services.auditlog.AuditLogService;

@EventName("tenantOnboarded")
public interface TenantOnboardedEventContext extends EventContext {
  String CDS_NAME = "tenantOnboarded";

  @Override
  AuditLogService getService();

  static TenantOnboardedEventContext create() {
    return EventContext.create(TenantOnboardedEventContext.class, null);
  }
}
