/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.auditlog.event;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cds.services.auditlog.AuditLogService;

@EventName("unauthorizedRequest")
public interface UnauthorizedRequestEventContext extends EventContext {
  String CDS_NAME = "unauthorizedRequest";

  @Override
  AuditLogService getService();

  static UnauthorizedRequestEventContext create() {
    return EventContext.create(UnauthorizedRequestEventContext.class, null);
  }
}
