/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.authorization;

import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

@EventName(AuthorizationService.EVENT_ENTITY_ACCESS)
public interface EntityAccessEventContext extends EventContext {

  static EntityAccessEventContext create(String entityName) {
    return EventContext.create(EntityAccessEventContext.class, entityName);
  }

  @Override
  AuthorizationService getService();

  // IN
  void setAccessQuery(CqnStatement query);

  CqnStatement getAccessQuery();

  void setAccessEntityName(String entity);

  String getAccessEntityName();

  void setAccessEventName(String event);

  String getAccessEventName();

  // OUT
  Boolean getResult();

  void setResult(boolean result);
}
