/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.cds;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import java.util.Map;

/** The specialized {@link EventContext} to be used for {@link CqnService#EVENT_UPSERT} */
@EventName(CqnService.EVENT_UPSERT)
public interface CdsUpsertEventContext extends EventContext {

  /**
   * Creates an {@link EventContext} already overlaid with this interface. The event is set to be
   * {@link CqnService#EVENT_UPSERT}
   *
   * @param entityName the name of the entity
   * @return the {@link CdsUpsertEventContext}
   */
  static CdsUpsertEventContext create(String entityName) {
    return EventContext.create(CdsUpsertEventContext.class, entityName);
  }

  @Override
  CqnService getService();

  // IN
  /**
   * @return the {@link CqnUpsert} statement
   */
  CqnUpsert getCqn();

  /**
   * Sets the {@link CqnUpsert} statement
   *
   * @param cqn the {@link CqnUpsert} statement
   */
  void setCqn(CqnUpsert cqn);

  // OUT
  /**
   * @return the {@link Result} of the {@link CqnService#EVENT_UPSERT} event
   */
  Result getResult();

  /**
   * Sets the result of the {@link CqnService#EVENT_UPSERT} event
   *
   * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link
   *     Result}
   */
  void setResult(Iterable<? extends Map<String, ?>> result);
}
