/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.draft;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import java.util.Map;

/** The {@link EventContext} for the {@link DraftService#EVENT_DRAFT_NEW} event. */
@EventName(DraftService.EVENT_DRAFT_NEW)
public interface DraftNewEventContext extends EventContext {

  /**
   * Creates an {@link EventContext} already overlaid with this interface. The event is set to be
   * {@link DraftService#EVENT_DRAFT_NEW}
   *
   * @param entityName the name of the entity
   * @return the {@link DraftNewEventContext}
   */
  static DraftNewEventContext create(String entityName) {
    return EventContext.create(DraftNewEventContext.class, entityName);
  }

  @Override
  DraftService getService();

  // IN
  /**
   * @return the {@link CqnInsert} statement
   */
  CqnInsert getCqn();

  /**
   * Sets the {@link CqnInsert} statement
   *
   * @param cqn the {@link CqnInsert} statement
   */
  void setCqn(CqnInsert cqn);

  // OUT
  /**
   * @return the {@link Result} of the {@link DraftService#EVENT_DRAFT_NEW} event
   */
  Result getResult();

  /**
   * Sets the result of the {@link DraftService#EVENT_DRAFT_NEW} event
   *
   * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link
   *     Result}
   */
  void setResult(Iterable<? extends Map<String, ?>> result);
}
