/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.handler;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;

/** Functional interface for programmatic handler registration on {@link Service} instances. */
@FunctionalInterface
public interface Handler {

  /**
   * Processes an {@link EventContext}
   *
   * @param context the {@link EventContext}
   */
  public void process(EventContext context);
}
