/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import java.util.Map;

@EventName(DeploymentService.EVENT_APP_UI_URL)
public interface AppUiUrlEventContext extends EventContext {

  /**
   * Creates an {@link EventContext} already overlaid with this interface. The event is set to be
   * {@link DeploymentService#EVENT_APP_UI_URL}
   *
   * @return the {@link AppUiUrlEventContext}
   */
  static AppUiUrlEventContext create() {
    return EventContext.create(AppUiUrlEventContext.class, null);
  }

  /**
   * @return the tenant ID
   */
  String getTenant();

  /**
   * Sets the tenant ID
   *
   * @param tenant the tenant ID
   */
  void setTenant(String tenant);

  /**
   * @return the subdomain
   */
  String getSubdomain();

  /**
   * Sets the subdomain
   *
   * @param subdomain the subdomain
   */
  void setSubdomain(String subdomain);

  /**
   * @return the optional additional options
   */
  Map<String, Object> getOptions();

  /**
   * Sets the optional additional options
   *
   * @param options the optional additional options
   */
  void setOptions(Map<String, Object> options);

  /**
   * @return the app UI URL
   */
  String getResult();

  /** Sets the app UI URL */
  void setResult(String appUiUrl);
}
