/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.mt;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;

/** Tenant info */
public interface TenantInfo extends CdsData {

  String TENANT = "tenant";
  String SUBDOMAIN = "subdomain";

  /**
   * Creates a new {@link TenantInfo}
   *
   * @return the {@link TenantInfo}
   */
  static TenantInfo create() {
    return Struct.create(TenantInfo.class);
  }

  /**
   * @return the tenant identifier
   */
  String getTenant();

  /**
   * Sets the tenant identifier
   *
   * @param tenant the tenant identifier
   */
  void setTenant(String tenant);

  /**
   * @return the subdomain
   */
  String getSubdomain();

  /**
   * Sets the subdomain
   *
   * @param subdomain the subdomain
   */
  void setSubdomain(String subdomain);
}
