/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.runtime;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.UserInfo;

/** A provider of tenant and feature toggle dependent CDS models. */
public interface CdsModelProvider extends CdsProvider<CdsModelProvider> {

  /**
   * Calculates the model for a user and a set of feature toggles.
   *
   * @param userInfo The {@link UserInfo}
   * @param featureTogglesInfo The {@link FeatureTogglesInfo}
   * @return The model for the respective user and set of feature toggles
   */
  CdsModel get(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo);
}
