/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.environment;

import com.sap.cds.docs.config.DocumentedProperty;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class CdsProperties {
    private Environment environment = new Environment();
    private DataSource dataSource = new DataSource();
    private Model model = new Model();
    private Security security = new Security();
    private Servlet indexPage = new Servlet("/", true);
    private ODataV4 odataV4 = new ODataV4();
    @DocumentedProperty(value=false)
    private ODataX4 odataX4 = new ODataX4();
    private ODataV2 odataV2 = new ODataV2();
    private Hcql hcql = new Hcql();
    private Messaging messaging = new Messaging();
    private MultiTenancy multiTenancy = new MultiTenancy();
    private Persistence persistence = new Persistence();
    private Application application = new Application();
    private Remote remote = new Remote();
    private Locales locales = new Locales();
    private Errors errors = new Errors();
    private Drafts drafts = new Drafts();
    private Query query = new Query();
    private Sql sql = new Sql();
    private AuditLog auditLog = new AuditLog();
    private Outbox outbox = new Outbox();
    private TaskScheduler taskScheduler = new TaskScheduler();
    @DocumentedProperty(value=false)
    private CloudSdk cloudSdk = new CloudSdk();
    private UnifiedCustomerLandscape ucl = new UnifiedCustomerLandscape();
    @DocumentedProperty(value=false)
    private OpenResourceDiscovery ord = new OpenResourceDiscovery();
    @DocumentedProperty(value=false)
    private Dashboard dashboard = new Dashboard();

    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }

    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public Model getModel() {
        return this.model;
    }

    @Generated
    public Security getSecurity() {
        return this.security;
    }

    @Generated
    public Servlet getIndexPage() {
        return this.indexPage;
    }

    @Generated
    public ODataV4 getOdataV4() {
        return this.odataV4;
    }

    @Generated
    public ODataX4 getOdataX4() {
        return this.odataX4;
    }

    @Generated
    public ODataV2 getOdataV2() {
        return this.odataV2;
    }

    @Generated
    public Hcql getHcql() {
        return this.hcql;
    }

    @Generated
    public Messaging getMessaging() {
        return this.messaging;
    }

    @Generated
    public MultiTenancy getMultiTenancy() {
        return this.multiTenancy;
    }

    @Generated
    public Persistence getPersistence() {
        return this.persistence;
    }

    @Generated
    public Application getApplication() {
        return this.application;
    }

    @Generated
    public Remote getRemote() {
        return this.remote;
    }

    @Generated
    public Locales getLocales() {
        return this.locales;
    }

    @Generated
    public Errors getErrors() {
        return this.errors;
    }

    @Generated
    public Drafts getDrafts() {
        return this.drafts;
    }

    @Generated
    public Query getQuery() {
        return this.query;
    }

    @Generated
    public Sql getSql() {
        return this.sql;
    }

    @Generated
    public AuditLog getAuditLog() {
        return this.auditLog;
    }

    @Generated
    public Outbox getOutbox() {
        return this.outbox;
    }

    @Generated
    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    @Generated
    public CloudSdk getCloudSdk() {
        return this.cloudSdk;
    }

    @Generated
    public UnifiedCustomerLandscape getUcl() {
        return this.ucl;
    }

    @Generated
    public OpenResourceDiscovery getOrd() {
        return this.ord;
    }

    @Generated
    public Dashboard getDashboard() {
        return this.dashboard;
    }

    @Generated
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Generated
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Generated
    public void setModel(Model model) {
        this.model = model;
    }

    @Generated
    public void setSecurity(Security security) {
        this.security = security;
    }

    @Generated
    public void setIndexPage(Servlet indexPage) {
        this.indexPage = indexPage;
    }

    @Generated
    public void setOdataV4(ODataV4 odataV4) {
        this.odataV4 = odataV4;
    }

    @Generated
    public void setOdataX4(ODataX4 odataX4) {
        this.odataX4 = odataX4;
    }

    @Generated
    public void setOdataV2(ODataV2 odataV2) {
        this.odataV2 = odataV2;
    }

    @Generated
    public void setHcql(Hcql hcql) {
        this.hcql = hcql;
    }

    @Generated
    public void setMessaging(Messaging messaging) {
        this.messaging = messaging;
    }

    @Generated
    public void setMultiTenancy(MultiTenancy multiTenancy) {
        this.multiTenancy = multiTenancy;
    }

    @Generated
    public void setPersistence(Persistence persistence) {
        this.persistence = persistence;
    }

    @Generated
    public void setApplication(Application application) {
        this.application = application;
    }

    @Generated
    public void setRemote(Remote remote) {
        this.remote = remote;
    }

    @Generated
    public void setLocales(Locales locales) {
        this.locales = locales;
    }

    @Generated
    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    @Generated
    public void setDrafts(Drafts drafts) {
        this.drafts = drafts;
    }

    @Generated
    public void setQuery(Query query) {
        this.query = query;
    }

    @Generated
    public void setSql(Sql sql) {
        this.sql = sql;
    }

    @Generated
    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    @Generated
    public void setOutbox(Outbox outbox) {
        this.outbox = outbox;
    }

    @Generated
    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    @Generated
    public void setCloudSdk(CloudSdk cloudSdk) {
        this.cloudSdk = cloudSdk;
    }

    @Generated
    public void setUcl(UnifiedCustomerLandscape ucl) {
        this.ucl = ucl;
    }

    @Generated
    public void setOrd(OpenResourceDiscovery ord) {
        this.ord = ord;
    }

    @Generated
    public void setDashboard(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    public static class Environment {
        private Local local = new Local();
        private Production production = new Production();
        private Deployment deployment = new Deployment();
        @DocumentedProperty(value=false)
        private Enabled command = new Enabled(false);

        @Generated
        public Local getLocal() {
            return this.local;
        }

        @Generated
        public Production getProduction() {
            return this.production;
        }

        @Generated
        public Deployment getDeployment() {
            return this.deployment;
        }

        @Generated
        public Enabled getCommand() {
            return this.command;
        }

        @Generated
        public void setLocal(Local local) {
            this.local = local;
        }

        @Generated
        public void setProduction(Production production) {
            this.production = production;
        }

        @Generated
        public void setDeployment(Deployment deployment) {
            this.deployment = deployment;
        }

        @Generated
        public void setCommand(Enabled command) {
            this.command = command;
        }

        public static class Local {
            private String defaultEnvPath;

            @Generated
            public String getDefaultEnvPath() {
                return this.defaultEnvPath;
            }

            @Generated
            public void setDefaultEnvPath(String defaultEnvPath) {
                this.defaultEnvPath = defaultEnvPath;
            }
        }

        public static class Production
        extends Enabled {
            private String profile = "cloud";

            public Production() {
                super(null);
            }

            @Generated
            public String getProfile() {
                return this.profile;
            }

            @Generated
            public void setProfile(String profile) {
                this.profile = profile;
            }
        }

        public static class Deployment {
            private String version;

            @Generated
            public String getVersion() {
                return this.version;
            }

            @Generated
            public void setVersion(String version) {
                this.version = version;
            }
        }
    }

    public static class DataSource {
        private Csv csv = new Csv();
        private Enabled autoConfig = new Enabled(true);
        private boolean embedded;
        private String binding;

        @Generated
        public Csv getCsv() {
            return this.csv;
        }

        @Generated
        public Enabled getAutoConfig() {
            return this.autoConfig;
        }

        @Generated
        public boolean isEmbedded() {
            return this.embedded;
        }

        @Generated
        public String getBinding() {
            return this.binding;
        }

        @Generated
        public void setCsv(Csv csv) {
            this.csv = csv;
        }

        @Generated
        public void setAutoConfig(Enabled autoConfig) {
            this.autoConfig = autoConfig;
        }

        @Generated
        public void setEmbedded(boolean embedded) {
            this.embedded = embedded;
        }

        @Generated
        public void setBinding(String binding) {
            this.binding = binding;
        }

        public static class Csv {
            private String initializationMode = "embedded";
            private String fileSuffix = ".csv";
            private List<String> paths = Arrays.asList("db/data/**", "db/csv/**", "../db/data/**", "../db/csv/**");
            private boolean singleChangeset;

            @Generated
            public String getInitializationMode() {
                return this.initializationMode;
            }

            @Generated
            public String getFileSuffix() {
                return this.fileSuffix;
            }

            @Generated
            public List<String> getPaths() {
                return this.paths;
            }

            @Generated
            public boolean isSingleChangeset() {
                return this.singleChangeset;
            }

            @Generated
            public void setInitializationMode(String initializationMode) {
                this.initializationMode = initializationMode;
            }

            @Generated
            public void setFileSuffix(String fileSuffix) {
                this.fileSuffix = fileSuffix;
            }

            @Generated
            public void setPaths(List<String> paths) {
                this.paths = paths;
            }

            @Generated
            public void setSingleChangeset(boolean singleChangeset) {
                this.singleChangeset = singleChangeset;
            }
        }
    }

    public static class Model {
        private String csnPath = "edmx/csn.json";
        @DocumentedProperty(value=false)
        private Enabled universalCsn = new Enabled(false);
        private Provider provider = new Provider();
        private boolean includeUiAnnotations = false;

        @Generated
        public String getCsnPath() {
            return this.csnPath;
        }

        @Generated
        public Enabled getUniversalCsn() {
            return this.universalCsn;
        }

        @Generated
        public Provider getProvider() {
            return this.provider;
        }

        @Generated
        public boolean isIncludeUiAnnotations() {
            return this.includeUiAnnotations;
        }

        @Generated
        public void setCsnPath(String csnPath) {
            this.csnPath = csnPath;
        }

        @Generated
        public void setUniversalCsn(Enabled universalCsn) {
            this.universalCsn = universalCsn;
        }

        @Generated
        public void setProvider(Provider provider) {
            this.provider = provider;
        }

        @Generated
        public void setIncludeUiAnnotations(boolean includeUiAnnotations) {
            this.includeUiAnnotations = includeUiAnnotations;
        }

        public static class Provider {
            private String url;
            private boolean extensibility = true;
            private boolean toggles = true;
            private Cache cache = new Cache();

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public boolean isExtensibility() {
                return this.extensibility;
            }

            @Generated
            public boolean isToggles() {
                return this.toggles;
            }

            @Generated
            public Cache getCache() {
                return this.cache;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public void setExtensibility(boolean extensibility) {
                this.extensibility = extensibility;
            }

            @Generated
            public void setToggles(boolean toggles) {
                this.toggles = toggles;
            }

            @Generated
            public void setCache(Cache cache) {
                this.cache = cache;
            }

            public static class Cache {
                private int maxSize = 20;
                private int expirationTime = 3600;
                private int refreshTime = 60;

                @Generated
                public int getMaxSize() {
                    return this.maxSize;
                }

                @Generated
                public int getExpirationTime() {
                    return this.expirationTime;
                }

                @Generated
                public int getRefreshTime() {
                    return this.refreshTime;
                }

                @Generated
                public void setMaxSize(int maxSize) {
                    this.maxSize = maxSize;
                }

                @Generated
                public void setExpirationTime(int expirationTime) {
                    this.expirationTime = expirationTime;
                }

                @Generated
                public void setRefreshTime(int refreshTime) {
                    this.refreshTime = refreshTime;
                }
            }
        }
    }

    public static class Security {
        private boolean logPotentiallySensitive = false;
        private Authentication authentication = new Authentication();
        private Authorization authorization = new Authorization();
        private Identity identity = new Identity();
        private Xsuaa xsuaa = new Xsuaa();
        private Mock mock = new Mock();

        @Generated
        public boolean isLogPotentiallySensitive() {
            return this.logPotentiallySensitive;
        }

        @Generated
        public Authentication getAuthentication() {
            return this.authentication;
        }

        @Generated
        public Authorization getAuthorization() {
            return this.authorization;
        }

        @Generated
        public Identity getIdentity() {
            return this.identity;
        }

        @Generated
        public Xsuaa getXsuaa() {
            return this.xsuaa;
        }

        @Generated
        public Mock getMock() {
            return this.mock;
        }

        @Generated
        public void setLogPotentiallySensitive(boolean logPotentiallySensitive) {
            this.logPotentiallySensitive = logPotentiallySensitive;
        }

        @Generated
        public void setAuthentication(Authentication authentication) {
            this.authentication = authentication;
        }

        @Generated
        public void setAuthorization(Authorization authorization) {
            this.authorization = authorization;
        }

        @Generated
        public void setIdentity(Identity identity) {
            this.identity = identity;
        }

        @Generated
        public void setXsuaa(Xsuaa xsuaa) {
            this.xsuaa = xsuaa;
        }

        @Generated
        public void setMock(Mock mock) {
            this.mock = mock;
        }

        public static class Authentication {
            private String mode = "model-strict";
            private boolean authenticateMetadataEndpoints = true;
            private boolean authenticateUnknownEndpoints = true;
            private boolean normalizeProviderTenant = true;
            private Enabled authConfig = new Enabled(true);
            private String clientCertificateHeader = "X-Forwarded-Client-Cert";
            private Enabled internalUserAccess = new Enabled(true);

            @Generated
            public String getMode() {
                return this.mode;
            }

            @Generated
            public boolean isAuthenticateMetadataEndpoints() {
                return this.authenticateMetadataEndpoints;
            }

            @Generated
            public boolean isAuthenticateUnknownEndpoints() {
                return this.authenticateUnknownEndpoints;
            }

            @Generated
            public boolean isNormalizeProviderTenant() {
                return this.normalizeProviderTenant;
            }

            @Generated
            public Enabled getAuthConfig() {
                return this.authConfig;
            }

            @Generated
            public String getClientCertificateHeader() {
                return this.clientCertificateHeader;
            }

            @Generated
            public Enabled getInternalUserAccess() {
                return this.internalUserAccess;
            }

            @Generated
            public void setMode(String mode) {
                this.mode = mode;
            }

            @Generated
            public void setAuthenticateMetadataEndpoints(boolean authenticateMetadataEndpoints) {
                this.authenticateMetadataEndpoints = authenticateMetadataEndpoints;
            }

            @Generated
            public void setAuthenticateUnknownEndpoints(boolean authenticateUnknownEndpoints) {
                this.authenticateUnknownEndpoints = authenticateUnknownEndpoints;
            }

            @Generated
            public void setNormalizeProviderTenant(boolean normalizeProviderTenant) {
                this.normalizeProviderTenant = normalizeProviderTenant;
            }

            @Generated
            public void setAuthConfig(Enabled authConfig) {
                this.authConfig = authConfig;
            }

            @Generated
            public void setClientCertificateHeader(String clientCertificateHeader) {
                this.clientCertificateHeader = clientCertificateHeader;
            }

            @Generated
            public void setInternalUserAccess(Enabled internalUserAccess) {
                this.internalUserAccess = internalUserAccess;
            }
        }

        public static class Authorization
        extends Enabled {
            private Enabled draftProtection = new Enabled(true);
            private Enabled deep = new Enabled(true);
            private InstanceBased instanceBased = new InstanceBased();

            public Authorization() {
                super(true);
            }

            @Generated
            public Enabled getDraftProtection() {
                return this.draftProtection;
            }

            @Generated
            public Enabled getDeep() {
                return this.deep;
            }

            @Generated
            public InstanceBased getInstanceBased() {
                return this.instanceBased;
            }

            @Generated
            public void setDraftProtection(Enabled draftProtection) {
                this.draftProtection = draftProtection;
            }

            @Generated
            public void setDeep(Enabled deep) {
                this.deep = deep;
            }

            @Generated
            public void setInstanceBased(InstanceBased instanceBased) {
                this.instanceBased = instanceBased;
            }

            public static class InstanceBased {
                @DocumentedProperty(value=false)
                private Enabled customEvents = new Enabled(true);
                private Enabled rejectSelectedUnauthorizedEntity = new Enabled(true);
                private Enabled checkInputData = new Enabled(true);

                @Generated
                public Enabled getCustomEvents() {
                    return this.customEvents;
                }

                @Generated
                public Enabled getRejectSelectedUnauthorizedEntity() {
                    return this.rejectSelectedUnauthorizedEntity;
                }

                @Generated
                public Enabled getCheckInputData() {
                    return this.checkInputData;
                }

                @Generated
                public void setCustomEvents(Enabled customEvents) {
                    this.customEvents = customEvents;
                }

                @Generated
                public void setRejectSelectedUnauthorizedEntity(Enabled rejectSelectedUnauthorizedEntity) {
                    this.rejectSelectedUnauthorizedEntity = rejectSelectedUnauthorizedEntity;
                }

                @Generated
                public void setCheckInputData(Enabled checkInputData) {
                    this.checkInputData = checkInputData;
                }
            }
        }

        public static class Identity
        extends Enabled {
            private String binding;
            private boolean exposePlansAsRoles = true;

            public Identity() {
                super(true);
            }

            @Generated
            public String getBinding() {
                return this.binding;
            }

            @Generated
            public boolean isExposePlansAsRoles() {
                return this.exposePlansAsRoles;
            }

            @Generated
            public void setBinding(String binding) {
                this.binding = binding;
            }

            @Generated
            public void setExposePlansAsRoles(boolean exposePlansAsRoles) {
                this.exposePlansAsRoles = exposePlansAsRoles;
            }
        }

        public static class Xsuaa
        extends Enabled {
            private String binding;
            @DocumentedProperty(value=false)
            @Deprecated(forRemoval=false)
            private boolean allowMultipleBindings = false;

            public Xsuaa() {
                super(true);
            }

            @Generated
            public String getBinding() {
                return this.binding;
            }

            @Deprecated
            @Generated
            public boolean isAllowMultipleBindings() {
                return this.allowMultipleBindings;
            }

            @Generated
            public void setBinding(String binding) {
                this.binding = binding;
            }

            @Deprecated
            @Generated
            public void setAllowMultipleBindings(boolean allowMultipleBindings) {
                this.allowMultipleBindings = allowMultipleBindings;
            }
        }

        public static class Mock
        extends Enabled {
            private Map<String, User> users = new HashMap<String, User>();
            private Enabled defaultUsers = new Enabled(true);
            private Map<String, Tenant> tenants = new HashMap<String, Tenant>();

            public Mock() {
                super(true);
            }

            public Map<String, User> getUsers() {
                this.users.forEach((k, v) -> {
                    if (v.getName() == null || v.getName().trim().isEmpty()) {
                        v.setName((String)k);
                    }
                });
                if (this.defaultUsers.isEnabled().booleanValue()) {
                    return this.withDefaultUsers(this.users);
                }
                return this.users;
            }

            private Map<String, User> withDefaultUsers(Map<String, User> configured) {
                HashMap<String, User> users = new HashMap<String, User>(configured);
                User authenticated = new User();
                authenticated.setName("authenticated");
                users.put("authenticated", authenticated);
                User system = new User();
                system.setName("system");
                system.setSystemUser(true);
                users.put("system", system);
                User internal = new User();
                internal.setName("internal");
                internal.setInternalUser(true);
                users.put("internal", internal);
                User privileged = new User();
                privileged.setName("privileged");
                privileged.setPrivileged(true);
                users.put("privileged", privileged);
                return users;
            }

            public Map<String, Tenant> getTenants() {
                this.tenants.forEach((k, v) -> {
                    if (v.getName() == null || v.getName().trim().isEmpty()) {
                        v.setName((String)k);
                    }
                });
                return this.tenants;
            }

            @Generated
            public Enabled getDefaultUsers() {
                return this.defaultUsers;
            }

            @Generated
            public void setUsers(Map<String, User> users) {
                this.users = users;
            }

            @Generated
            public void setDefaultUsers(Enabled defaultUsers) {
                this.defaultUsers = defaultUsers;
            }

            @Generated
            public void setTenants(Map<String, Tenant> tenants) {
                this.tenants = tenants;
            }

            public static class User {
                private String id;
                private String name;
                private String password = "";
                private String tenant;
                private boolean systemUser = false;
                private boolean privileged = false;
                private boolean internalUser = false;
                private List<String> roles = new ArrayList<String>();
                private List<String> features;
                private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
                private Map<String, Object> additional = new HashMap<String, Object>();
                private List<String> policies;

                public List<String> getPolicies() {
                    return (List)this.additional.get("policies");
                }

                public void setPolicies(List<String> policies) {
                    this.additional.put("policies", policies);
                }

                public boolean isValid() {
                    return this.getName() != null && !this.getName().isEmpty() && this.getPassword() != null;
                }

                @Generated
                public String getId() {
                    return this.id;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public String getPassword() {
                    return this.password;
                }

                @Generated
                public String getTenant() {
                    return this.tenant;
                }

                @Generated
                public boolean isSystemUser() {
                    return this.systemUser;
                }

                @Generated
                public boolean isPrivileged() {
                    return this.privileged;
                }

                @Generated
                public boolean isInternalUser() {
                    return this.internalUser;
                }

                @Generated
                public List<String> getRoles() {
                    return this.roles;
                }

                @Generated
                public List<String> getFeatures() {
                    return this.features;
                }

                @Generated
                public Map<String, List<String>> getAttributes() {
                    return this.attributes;
                }

                @Generated
                public Map<String, Object> getAdditional() {
                    return this.additional;
                }

                @Generated
                public void setId(String id) {
                    this.id = id;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }

                @Generated
                public void setPassword(String password) {
                    this.password = password;
                }

                @Generated
                public void setTenant(String tenant) {
                    this.tenant = tenant;
                }

                @Generated
                public void setSystemUser(boolean systemUser) {
                    this.systemUser = systemUser;
                }

                @Generated
                public void setPrivileged(boolean privileged) {
                    this.privileged = privileged;
                }

                @Generated
                public void setInternalUser(boolean internalUser) {
                    this.internalUser = internalUser;
                }

                @Generated
                public void setRoles(List<String> roles) {
                    this.roles = roles;
                }

                @Generated
                public void setFeatures(List<String> features) {
                    this.features = features;
                }

                @Generated
                public void setAttributes(Map<String, List<String>> attributes) {
                    this.attributes = attributes;
                }

                @Generated
                public void setAdditional(Map<String, Object> additional) {
                    this.additional = additional;
                }
            }

            public static class Tenant {
                private String name;
                private List<String> features = new ArrayList<String>();

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public List<String> getFeatures() {
                    return this.features;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }

                @Generated
                public void setFeatures(List<String> features) {
                    this.features = features;
                }
            }
        }
    }

    public static class Servlet
    extends Enabled {
        private String path;

        public Servlet() {
            super(true);
        }

        public Servlet(String path, boolean enabled) {
            super(enabled);
            this.path = path;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class ODataV4 {
        private Servlet endpoint = new Servlet("/odata/v4", true);
        private FioriPreview fioriPreview = new FioriPreview();
        private boolean contextAbsoluteUrl = false;
        private String edmxPath = "edmx/v4";
        private Enabled lazyI18n = new Enabled(true);
        @DocumentedProperty(value=false)
        private Enabled cdsToEdm = new Enabled(false);
        private Batch batch = new Batch();
        @DocumentedProperty(value=false)
        private Apply apply = new Apply();
        private String searchMode = "odata-lenient";

        @Generated
        public Servlet getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public FioriPreview getFioriPreview() {
            return this.fioriPreview;
        }

        @Generated
        public boolean isContextAbsoluteUrl() {
            return this.contextAbsoluteUrl;
        }

        @Generated
        public String getEdmxPath() {
            return this.edmxPath;
        }

        @Generated
        public Enabled getLazyI18n() {
            return this.lazyI18n;
        }

        @Generated
        public Enabled getCdsToEdm() {
            return this.cdsToEdm;
        }

        @Generated
        public Batch getBatch() {
            return this.batch;
        }

        @Generated
        public Apply getApply() {
            return this.apply;
        }

        @Generated
        public String getSearchMode() {
            return this.searchMode;
        }

        @Generated
        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setFioriPreview(FioriPreview fioriPreview) {
            this.fioriPreview = fioriPreview;
        }

        @Generated
        public void setContextAbsoluteUrl(boolean contextAbsoluteUrl) {
            this.contextAbsoluteUrl = contextAbsoluteUrl;
        }

        @Generated
        public void setEdmxPath(String edmxPath) {
            this.edmxPath = edmxPath;
        }

        @Generated
        public void setLazyI18n(Enabled lazyI18n) {
            this.lazyI18n = lazyI18n;
        }

        @Generated
        public void setCdsToEdm(Enabled cdsToEdm) {
            this.cdsToEdm = cdsToEdm;
        }

        @Generated
        public void setBatch(Batch batch) {
            this.batch = batch;
        }

        @Generated
        public void setApply(Apply apply) {
            this.apply = apply;
        }

        @Generated
        public void setSearchMode(String searchMode) {
            this.searchMode = searchMode;
        }

        public static class FioriPreview
        extends Enabled {
            private UI5 ui5 = new UI5();

            public FioriPreview() {
                super(true);
            }

            @Generated
            public UI5 getUi5() {
                return this.ui5;
            }

            @Generated
            public void setUi5(UI5 ui5) {
                this.ui5 = ui5;
            }

            public static class UI5 {
                private String version;
                private String host = "https://sapui5.hana.ondemand.com";

                @Generated
                public String getVersion() {
                    return this.version;
                }

                @Generated
                public String getHost() {
                    return this.host;
                }

                @Generated
                public void setVersion(String version) {
                    this.version = version;
                }

                @Generated
                public void setHost(String host) {
                    this.host = host;
                }
            }
        }

        public static class Batch {
            private long maxRequests = -1L;

            @Generated
            public long getMaxRequests() {
                return this.maxRequests;
            }

            @Generated
            public void setMaxRequests(long maxRequests) {
                this.maxRequests = maxRequests;
            }
        }

        public static class Apply {
            private Enabled transformations = new Enabled(false);

            @Generated
            public Enabled getTransformations() {
                return this.transformations;
            }

            @Generated
            public void setTransformations(Enabled transformations) {
                this.transformations = transformations;
            }
        }
    }

    public static class ODataX4 {
        private Servlet endpoint = new Servlet("/odata/x4", false);
        private String edmxPath = "edmx/odata/x4";

        @Generated
        public Servlet getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public String getEdmxPath() {
            return this.edmxPath;
        }

        @Generated
        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setEdmxPath(String edmxPath) {
            this.edmxPath = edmxPath;
        }
    }

    public static class ODataV2 {
        private Servlet endpoint = new Servlet("/odata/v2", true);
        private String edmxPath = "edmx/v2";
        private boolean caseSensitiveFilter = true;
        private String searchMode = "odata-lenient";
        private Batch batch = new Batch();

        @Generated
        public Servlet getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public String getEdmxPath() {
            return this.edmxPath;
        }

        @Generated
        public boolean isCaseSensitiveFilter() {
            return this.caseSensitiveFilter;
        }

        @Generated
        public String getSearchMode() {
            return this.searchMode;
        }

        @Generated
        public Batch getBatch() {
            return this.batch;
        }

        @Generated
        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setEdmxPath(String edmxPath) {
            this.edmxPath = edmxPath;
        }

        @Generated
        public void setCaseSensitiveFilter(boolean caseSensitiveFilter) {
            this.caseSensitiveFilter = caseSensitiveFilter;
        }

        @Generated
        public void setSearchMode(String searchMode) {
            this.searchMode = searchMode;
        }

        @Generated
        public void setBatch(Batch batch) {
            this.batch = batch;
        }

        public static class Batch {
            private long maxRequests = -1L;

            @Generated
            public long getMaxRequests() {
                return this.maxRequests;
            }

            @Generated
            public void setMaxRequests(long maxRequests) {
                this.maxRequests = maxRequests;
            }
        }
    }

    public static class Hcql {
        private Servlet endpoint = new Servlet("/hcql", true);

        @Generated
        public Servlet getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }
    }

    public static class Messaging {
        private MessagingWebhooks webhooks = new MessagingWebhooks();
        @DocumentedProperty(value=false)
        private boolean resetQueues = false;
        private List<Composite.CompositeServiceConfig.Route> routes = new ArrayList<Composite.CompositeServiceConfig.Route>();
        private Map<String, MessagingServiceConfig> services = new HashMap<String, MessagingServiceConfig>();

        public Map<String, MessagingServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public MessagingServiceConfig getService(String name) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getName(), name)).findFirst().orElse(new MessagingServiceConfig(name));
        }

        public List<MessagingServiceConfig> getServicesByKind(String kind) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getKind(), kind)).collect(Collectors.toList());
        }

        public List<MessagingServiceConfig> getServicesByBinding(String binding) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getBinding(), binding) || s.getBinding() == null && Objects.equals(s.getName(), binding)).collect(Collectors.toList());
        }

        @Generated
        public MessagingWebhooks getWebhooks() {
            return this.webhooks;
        }

        @Generated
        public boolean isResetQueues() {
            return this.resetQueues;
        }

        @Generated
        public List<Composite.CompositeServiceConfig.Route> getRoutes() {
            return this.routes;
        }

        @Generated
        public void setWebhooks(MessagingWebhooks webhooks) {
            this.webhooks = webhooks;
        }

        @Generated
        public void setResetQueues(boolean resetQueues) {
            this.resetQueues = resetQueues;
        }

        @Generated
        public void setRoutes(List<Composite.CompositeServiceConfig.Route> routes) {
            this.routes = routes;
        }

        @Generated
        public void setServices(Map<String, MessagingServiceConfig> services) {
            this.services = services;
        }

        public static class MessagingWebhooks
        extends Enabled {
            private String url;

            public MessagingWebhooks() {
                super(true);
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }
        }

        public static class MessagingServiceConfig
        extends Enabled {
            private String name;
            private String kind;
            private String binding;
            private String subscribePrefix;
            private String publishPrefix;
            private String format;
            private Connection connection = new Connection();
            private Queue queue = new Queue();
            private Outbox outbox = new Outbox();
            private Inbox inbox = new Inbox();

            public MessagingServiceConfig() {
                super(true);
            }

            public MessagingServiceConfig(String name) {
                super(true);
                this.name = name;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getKind() {
                return this.kind;
            }

            @Generated
            public String getBinding() {
                return this.binding;
            }

            @Generated
            public String getSubscribePrefix() {
                return this.subscribePrefix;
            }

            @Generated
            public String getPublishPrefix() {
                return this.publishPrefix;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }

            @Generated
            public Connection getConnection() {
                return this.connection;
            }

            @Generated
            public Queue getQueue() {
                return this.queue;
            }

            @Generated
            public Outbox getOutbox() {
                return this.outbox;
            }

            @Generated
            public Inbox getInbox() {
                return this.inbox;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setKind(String kind) {
                this.kind = kind;
            }

            @Generated
            public void setBinding(String binding) {
                this.binding = binding;
            }

            @Generated
            public void setSubscribePrefix(String subscribePrefix) {
                this.subscribePrefix = subscribePrefix;
            }

            @Generated
            public void setPublishPrefix(String publishPrefix) {
                this.publishPrefix = publishPrefix;
            }

            @Generated
            public void setFormat(String format) {
                this.format = format;
            }

            @Generated
            public void setConnection(Connection connection) {
                this.connection = connection;
            }

            @Generated
            public void setQueue(Queue queue) {
                this.queue = queue;
            }

            @Generated
            public void setOutbox(Outbox outbox) {
                this.outbox = outbox;
            }

            @Generated
            public void setInbox(Inbox inbox) {
                this.inbox = inbox;
            }

            public static class Connection {
                private boolean dedicated = false;
                private Map<String, String> properties = new HashMap<String, String>();
                @DocumentedProperty(value=false)
                private ConnectionPool connectionPool = new ConnectionPool();

                @Generated
                public boolean isDedicated() {
                    return this.dedicated;
                }

                @Generated
                public Map<String, String> getProperties() {
                    return this.properties;
                }

                @Generated
                public ConnectionPool getConnectionPool() {
                    return this.connectionPool;
                }

                @Generated
                public void setDedicated(boolean dedicated) {
                    this.dedicated = dedicated;
                }

                @Generated
                public void setProperties(Map<String, String> properties) {
                    this.properties = properties;
                }

                @Generated
                public void setConnectionPool(ConnectionPool connectionPool) {
                    this.connectionPool = connectionPool;
                }
            }

            public static class Queue {
                private String name;
                private Map<String, Object> config = new HashMap<String, Object>();
                private List<String> subscriptions = new ArrayList<String>();
                private boolean forceListening = false;

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public Map<String, Object> getConfig() {
                    return this.config;
                }

                @Generated
                public List<String> getSubscriptions() {
                    return this.subscriptions;
                }

                @Generated
                public boolean isForceListening() {
                    return this.forceListening;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }

                @Generated
                public void setConfig(Map<String, Object> config) {
                    this.config = config;
                }

                @Generated
                public void setSubscriptions(List<String> subscriptions) {
                    this.subscriptions = subscriptions;
                }

                @Generated
                public void setForceListening(boolean forceListening) {
                    this.forceListening = forceListening;
                }
            }

            public static class Outbox
            extends Enabled {
                private String name = "DefaultOutboxOrdered";

                public Outbox() {
                    super(true);
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }
            }

            public static class Inbox
            extends Enabled {
                private String name = "DefaultOutboxOrdered";

                public Inbox() {
                    super(false);
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }
            }
        }
    }

    public static class MultiTenancy {
        private Servlet endpoint = new Servlet("/mt/v1.0/subscriptions", true);
        private SubscriptionManager subscriptionManager = new SubscriptionManager();
        private DataSource dataSource = new DataSource();
        private ServiceManager serviceManager = new ServiceManager();
        private HanaMtService hanaMtService = new HanaMtService();
        private Security security = new Security();
        @Deprecated
        @DocumentedProperty(value=false)
        private Deployer deployer = new Deployer();
        private Sidecar sidecar = new Sidecar();
        private AppUi appUi = new AppUi();
        private HealthCheck healthCheck = new HealthCheck();
        private Liquibase liquibase = new Liquibase();
        private ProvisioningService provisioning = new ProvisioningService();
        private Mock mock = new Mock();
        private String componentScan;
        private Dependencies dependencies = new Dependencies();

        @Generated
        public Servlet getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public SubscriptionManager getSubscriptionManager() {
            return this.subscriptionManager;
        }

        @Generated
        public DataSource getDataSource() {
            return this.dataSource;
        }

        @Generated
        public ServiceManager getServiceManager() {
            return this.serviceManager;
        }

        @Generated
        public HanaMtService getHanaMtService() {
            return this.hanaMtService;
        }

        @Generated
        public Security getSecurity() {
            return this.security;
        }

        @Deprecated
        @Generated
        public Deployer getDeployer() {
            return this.deployer;
        }

        @Generated
        public Sidecar getSidecar() {
            return this.sidecar;
        }

        @Generated
        public AppUi getAppUi() {
            return this.appUi;
        }

        @Generated
        public HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Generated
        public Liquibase getLiquibase() {
            return this.liquibase;
        }

        @Generated
        public ProvisioningService getProvisioning() {
            return this.provisioning;
        }

        @Generated
        public Mock getMock() {
            return this.mock;
        }

        @Generated
        public String getComponentScan() {
            return this.componentScan;
        }

        @Generated
        public Dependencies getDependencies() {
            return this.dependencies;
        }

        @Generated
        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
            this.subscriptionManager = subscriptionManager;
        }

        @Generated
        public void setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Generated
        public void setServiceManager(ServiceManager serviceManager) {
            this.serviceManager = serviceManager;
        }

        @Generated
        public void setHanaMtService(HanaMtService hanaMtService) {
            this.hanaMtService = hanaMtService;
        }

        @Generated
        public void setSecurity(Security security) {
            this.security = security;
        }

        @Deprecated
        @Generated
        public void setDeployer(Deployer deployer) {
            this.deployer = deployer;
        }

        @Generated
        public void setSidecar(Sidecar sidecar) {
            this.sidecar = sidecar;
        }

        @Generated
        public void setAppUi(AppUi appUi) {
            this.appUi = appUi;
        }

        @Generated
        public void setHealthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        @Generated
        public void setLiquibase(Liquibase liquibase) {
            this.liquibase = liquibase;
        }

        @Generated
        public void setProvisioning(ProvisioningService provisioning) {
            this.provisioning = provisioning;
        }

        @Generated
        public void setMock(Mock mock) {
            this.mock = mock;
        }

        @Generated
        public void setComponentScan(String componentScan) {
            this.componentScan = componentScan;
        }

        @Generated
        public void setDependencies(Dependencies dependencies) {
            this.dependencies = dependencies;
        }

        public static class SubscriptionManager {
            private Servlet endpoint = new Servlet("/mt/sms/subscriptions", true);

            @Generated
            public Servlet getEndpoint() {
                return this.endpoint;
            }

            @Generated
            public void setEndpoint(Servlet endpoint) {
                this.endpoint = endpoint;
            }
        }

        public static class DataSource {
            private String pool = "hikari";
            private Enabled combinePools = new Enabled(false);
            private String hanaEncryptionMode;
            @DocumentedProperty(value=false)
            private Enabled x509 = new Enabled(false);

            @Generated
            public String getPool() {
                return this.pool;
            }

            @Generated
            public Enabled getCombinePools() {
                return this.combinePools;
            }

            @Generated
            public String getHanaEncryptionMode() {
                return this.hanaEncryptionMode;
            }

            @Generated
            public Enabled getX509() {
                return this.x509;
            }

            @Generated
            public void setPool(String pool) {
                this.pool = pool;
            }

            @Generated
            public void setCombinePools(Enabled combinePools) {
                this.combinePools = combinePools;
            }

            @Generated
            public void setHanaEncryptionMode(String hanaEncryptionMode) {
                this.hanaEncryptionMode = hanaEncryptionMode;
            }

            @Generated
            public void setX509(Enabled x509) {
                this.x509 = x509;
            }
        }

        public static class ServiceManager {
            private Duration cacheRefreshInterval = Duration.ofMinutes(2L);
            @DocumentedProperty(value=false)
            private Enabled acceptInstancesWithoutTenant = new Enabled(false);
            @DocumentedProperty(value=false)
            private Enabled ignoreDuplicateTenantInstances = new Enabled(false);
            private Duration tokenRetrievalTimeout = Duration.ofSeconds(30L);
            @DocumentedProperty(value=false)
            private Enabled v2 = new Enabled(false);
            @DocumentedProperty(value=false)
            private Duration singleReadInterval = Duration.ZERO;

            @Generated
            public Duration getCacheRefreshInterval() {
                return this.cacheRefreshInterval;
            }

            @Generated
            public Enabled getAcceptInstancesWithoutTenant() {
                return this.acceptInstancesWithoutTenant;
            }

            @Generated
            public Enabled getIgnoreDuplicateTenantInstances() {
                return this.ignoreDuplicateTenantInstances;
            }

            @Generated
            public Duration getTokenRetrievalTimeout() {
                return this.tokenRetrievalTimeout;
            }

            @Generated
            public Enabled getV2() {
                return this.v2;
            }

            @Generated
            public Duration getSingleReadInterval() {
                return this.singleReadInterval;
            }

            @Generated
            public void setCacheRefreshInterval(Duration cacheRefreshInterval) {
                this.cacheRefreshInterval = cacheRefreshInterval;
            }

            @Generated
            public void setAcceptInstancesWithoutTenant(Enabled acceptInstancesWithoutTenant) {
                this.acceptInstancesWithoutTenant = acceptInstancesWithoutTenant;
            }

            @Generated
            public void setIgnoreDuplicateTenantInstances(Enabled ignoreDuplicateTenantInstances) {
                this.ignoreDuplicateTenantInstances = ignoreDuplicateTenantInstances;
            }

            @Generated
            public void setTokenRetrievalTimeout(Duration tokenRetrievalTimeout) {
                this.tokenRetrievalTimeout = tokenRetrievalTimeout;
            }

            @Generated
            public void setV2(Enabled v2) {
                this.v2 = v2;
            }

            @Generated
            public void setSingleReadInterval(Duration singleReadInterval) {
                this.singleReadInterval = singleReadInterval;
            }
        }

        public static class HanaMtService {
            private Duration tokenRetrievalTimeout = Duration.ofSeconds(30L);
            private String hanaTenantPrefix;

            @Generated
            public Duration getTokenRetrievalTimeout() {
                return this.tokenRetrievalTimeout;
            }

            @Generated
            public String getHanaTenantPrefix() {
                return this.hanaTenantPrefix;
            }

            @Generated
            public void setTokenRetrievalTimeout(Duration tokenRetrievalTimeout) {
                this.tokenRetrievalTimeout = tokenRetrievalTimeout;
            }

            @Generated
            public void setHanaTenantPrefix(String hanaTenantPrefix) {
                this.hanaTenantPrefix = hanaTenantPrefix;
            }
        }

        public static class Security {
            private String subscriptionScope = "mtcallback";

            @Generated
            public String getSubscriptionScope() {
                return this.subscriptionScope;
            }

            @Generated
            public void setSubscriptionScope(String subscriptionScope) {
                this.subscriptionScope = subscriptionScope;
            }
        }

        public static class Deployer {
            private String url;
            private String user;
            @DocumentedProperty(sensitive=true)
            private String password;
            private Duration asyncTimeout = Duration.ofMinutes(10L);

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public String getUser() {
                return this.user;
            }

            @Generated
            public String getPassword() {
                return this.password;
            }

            @Generated
            public Duration getAsyncTimeout() {
                return this.asyncTimeout;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public void setUser(String user) {
                this.user = user;
            }

            @Generated
            public void setPassword(String password) {
                this.password = password;
            }

            @Generated
            public void setAsyncTimeout(Duration asyncTimeout) {
                this.asyncTimeout = asyncTimeout;
            }
        }

        public static class Sidecar {
            private String url;
            private Duration pollingInterval = Duration.ofSeconds(5L);
            private Duration pollingTimeout = Duration.ofMinutes(20L);

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public Duration getPollingInterval() {
                return this.pollingInterval;
            }

            @Generated
            public Duration getPollingTimeout() {
                return this.pollingTimeout;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public void setPollingInterval(Duration pollingInterval) {
                this.pollingInterval = pollingInterval;
            }

            @Generated
            public void setPollingTimeout(Duration pollingTimeout) {
                this.pollingTimeout = pollingTimeout;
            }
        }

        public static class AppUi {
            private String url;
            private String tenantSeparator;

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public String getTenantSeparator() {
                return this.tenantSeparator;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public void setTenantSeparator(String tenantSeparator) {
                this.tenantSeparator = tenantSeparator;
            }
        }

        public static class HealthCheck
        extends Enabled {
            private String healthCheckStatement = "";
            private Duration interval = Duration.ofSeconds(10L);

            public HealthCheck() {
                super(true);
            }

            @Generated
            public String getHealthCheckStatement() {
                return this.healthCheckStatement;
            }

            @Generated
            public Duration getInterval() {
                return this.interval;
            }

            @Generated
            public void setHealthCheckStatement(String healthCheckStatement) {
                this.healthCheckStatement = healthCheckStatement;
            }

            @Generated
            public void setInterval(Duration interval) {
                this.interval = interval;
            }
        }

        public static class Liquibase {
            private String changeLog = "/db/changelog/db.changelog-master.yaml";
            private String contexts;

            @Generated
            public String getChangeLog() {
                return this.changeLog;
            }

            @Generated
            public String getContexts() {
                return this.contexts;
            }

            @Generated
            public void setChangeLog(String changeLog) {
                this.changeLog = changeLog;
            }

            @Generated
            public void setContexts(String contexts) {
                this.contexts = contexts;
            }
        }

        public static class ProvisioningService {
            private String url;
            private Duration pollingInterval = Duration.ofSeconds(5L);
            private Duration pollingTimeout = Duration.ofMinutes(10L);

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public Duration getPollingInterval() {
                return this.pollingInterval;
            }

            @Generated
            public Duration getPollingTimeout() {
                return this.pollingTimeout;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public void setPollingInterval(Duration pollingInterval) {
                this.pollingInterval = pollingInterval;
            }

            @Generated
            public void setPollingTimeout(Duration pollingTimeout) {
                this.pollingTimeout = pollingTimeout;
            }
        }

        public static class Mock
        extends Enabled {
            private String sqliteDirectory;

            public Mock() {
                super(null);
            }

            @Generated
            public String getSqliteDirectory() {
                return this.sqliteDirectory;
            }

            @Generated
            public void setSqliteDirectory(String sqliteDirectory) {
                this.sqliteDirectory = sqliteDirectory;
            }
        }

        public static class Dependencies {
            private boolean destination = false;
            private boolean portal = true;
            private boolean html5AppsRepo = true;

            @Generated
            public boolean isDestination() {
                return this.destination;
            }

            @Generated
            public boolean isPortal() {
                return this.portal;
            }

            @Generated
            public boolean isHtml5AppsRepo() {
                return this.html5AppsRepo;
            }

            @Generated
            public void setDestination(boolean destination) {
                this.destination = destination;
            }

            @Generated
            public void setPortal(boolean portal) {
                this.portal = portal;
            }

            @Generated
            public void setHtml5AppsRepo(boolean html5AppsRepo) {
                this.html5AppsRepo = html5AppsRepo;
            }
        }
    }

    public static class Persistence {
        private Map<String, PersistenceServiceConfig> services = new HashMap<String, PersistenceServiceConfig>();
        private ChangeSet changeSet = new ChangeSet();

        public Map<String, PersistenceServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        @Generated
        public ChangeSet getChangeSet() {
            return this.changeSet;
        }

        @Generated
        public void setServices(Map<String, PersistenceServiceConfig> services) {
            this.services = services;
        }

        @Generated
        public void setChangeSet(ChangeSet changeSet) {
            this.changeSet = changeSet;
        }

        public static class ChangeSet {
            private boolean enforceTransactional = true;

            @Generated
            public boolean isEnforceTransactional() {
                return this.enforceTransactional;
            }

            @Generated
            public void setEnforceTransactional(boolean enforceTransactional) {
                this.enforceTransactional = enforceTransactional;
            }
        }

        public static class PersistenceServiceConfig
        extends Enabled {
            private String name;
            private String binding;
            private String dataSource;
            private String transactionManager;

            public PersistenceServiceConfig() {
                super(true);
            }

            public PersistenceServiceConfig(String name) {
                this();
                this.name = name;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getBinding() {
                return this.binding;
            }

            @Generated
            public String getDataSource() {
                return this.dataSource;
            }

            @Generated
            public String getTransactionManager() {
                return this.transactionManager;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setBinding(String binding) {
                this.binding = binding;
            }

            @Generated
            public void setDataSource(String dataSource) {
                this.dataSource = dataSource;
            }

            @Generated
            public void setTransactionManager(String transactionManager) {
                this.transactionManager = transactionManager;
            }
        }
    }

    public static class Application {
        private Map<String, ApplicationServiceConfig> services = new HashMap<String, ApplicationServiceConfig>();

        public Map<String, ApplicationServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public ApplicationServiceConfig getService(String name) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getName(), name)).findFirst().orElse(new ApplicationServiceConfig(name));
        }

        public List<ApplicationServiceConfig> getServicesByModel(String model) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getModel(), model) || s.getModel() == null && Objects.equals(s.getName(), model)).collect(Collectors.toList());
        }

        @Generated
        public void setServices(Map<String, ApplicationServiceConfig> services) {
            this.services = services;
        }

        public static class ApplicationServiceConfig {
            private String name;
            private String model;
            private Serve serve = new Serve();

            public ApplicationServiceConfig() {
            }

            public ApplicationServiceConfig(String name) {
                this.name = name;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getModel() {
                return this.model;
            }

            @Generated
            public Serve getServe() {
                return this.serve;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setModel(String model) {
                this.model = model;
            }

            @Generated
            public void setServe(Serve serve) {
                this.serve = serve;
            }

            public static class Serve {
                private boolean ignore;
                private String path;
                private List<String> protocols = new ArrayList<String>();
                private List<Endpoint> endpoints = new ArrayList<Endpoint>();

                @Generated
                public boolean isIgnore() {
                    return this.ignore;
                }

                @Generated
                public String getPath() {
                    return this.path;
                }

                @Generated
                public List<String> getProtocols() {
                    return this.protocols;
                }

                @Generated
                public List<Endpoint> getEndpoints() {
                    return this.endpoints;
                }

                @Generated
                public void setIgnore(boolean ignore) {
                    this.ignore = ignore;
                }

                @Generated
                public void setPath(String path) {
                    this.path = path;
                }

                @Generated
                public void setProtocols(List<String> protocols) {
                    this.protocols = protocols;
                }

                @Generated
                public void setEndpoints(List<Endpoint> endpoints) {
                    this.endpoints = endpoints;
                }

                public static class Endpoint {
                    private String path;
                    private String protocol;

                    @Generated
                    public String getPath() {
                        return this.path;
                    }

                    @Generated
                    public String getProtocol() {
                        return this.protocol;
                    }

                    @Generated
                    public void setPath(String path) {
                        this.path = path;
                    }

                    @Generated
                    public void setProtocol(String protocol) {
                        this.protocol = protocol;
                    }
                }
            }
        }
    }

    public static class Remote {
        private Map<String, RemoteServiceConfig> services = new HashMap<String, RemoteServiceConfig>();

        public Map<String, RemoteServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public RemoteServiceConfig getService(String name) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getName(), name)).findFirst().orElse(new RemoteServiceConfig(name));
        }

        public List<RemoteServiceConfig> getServicesByModel(String model) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getModel(), model) || s.getModel() == null && Objects.equals(s.getName(), model)).collect(Collectors.toList());
        }

        @Generated
        public void setServices(Map<String, RemoteServiceConfig> services) {
            this.services = services;
        }

        public static class RemoteServiceConfig {
            public static final String ODATA_V2_TYPE = "odata-v2";
            public static final String ODATA_V4_TYPE = "odata-v4";
            public static final String HCQL_TYPE = "hcql";
            public static final String RFC_TYPE = "rfc";
            private String name;
            private String model;
            private String type = "odata-v4";
            private Http http = new Http();
            private Destination destination = new Destination();
            private Binding binding = new Binding();
            @DocumentedProperty(value=false)
            private Rfc rfc = new Rfc();

            public RemoteServiceConfig() {
            }

            public RemoteServiceConfig(String name) {
                this.name = name;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getModel() {
                return this.model;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public Http getHttp() {
                return this.http;
            }

            @Generated
            public Destination getDestination() {
                return this.destination;
            }

            @Generated
            public Binding getBinding() {
                return this.binding;
            }

            @Generated
            public Rfc getRfc() {
                return this.rfc;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setModel(String model) {
                this.model = model;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public void setHttp(Http http) {
                this.http = http;
            }

            @Generated
            public void setDestination(Destination destination) {
                this.destination = destination;
            }

            @Generated
            public void setBinding(Binding binding) {
                this.binding = binding;
            }

            @Generated
            public void setRfc(Rfc rfc) {
                this.rfc = rfc;
            }

            public static class Http {
                private String suffix;
                private String service;
                @DocumentedProperty(sensitive=true)
                private Map<String, String> headers = new HashMap<String, String>();
                private Map<String, String> queries = new HashMap<String, String>();
                private Enabled csrf = new Enabled(false);

                @Generated
                public String getSuffix() {
                    return this.suffix;
                }

                @Generated
                public String getService() {
                    return this.service;
                }

                @Generated
                public Map<String, String> getHeaders() {
                    return this.headers;
                }

                @Generated
                public Map<String, String> getQueries() {
                    return this.queries;
                }

                @Generated
                public Enabled getCsrf() {
                    return this.csrf;
                }

                @Generated
                public void setSuffix(String suffix) {
                    this.suffix = suffix;
                }

                @Generated
                public void setService(String service) {
                    this.service = service;
                }

                @Generated
                public void setHeaders(Map<String, String> headers) {
                    this.headers = headers;
                }

                @Generated
                public void setQueries(Map<String, String> queries) {
                    this.queries = queries;
                }

                @Generated
                public void setCsrf(Enabled csrf) {
                    this.csrf = csrf;
                }
            }

            public static class Destination {
                private String name;
                @DocumentedProperty(sensitive=true)
                private Map<String, Object> properties = new HashMap<String, Object>();
                private String retrievalStrategy;
                private String tokenExchangeStrategy;

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public Map<String, Object> getProperties() {
                    return this.properties;
                }

                @Generated
                public String getRetrievalStrategy() {
                    return this.retrievalStrategy;
                }

                @Generated
                public String getTokenExchangeStrategy() {
                    return this.tokenExchangeStrategy;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }

                @Generated
                public void setProperties(Map<String, Object> properties) {
                    this.properties = properties;
                }

                @Generated
                public void setRetrievalStrategy(String retrievalStrategy) {
                    this.retrievalStrategy = retrievalStrategy;
                }

                @Generated
                public void setTokenExchangeStrategy(String tokenExchangeStrategy) {
                    this.tokenExchangeStrategy = tokenExchangeStrategy;
                }
            }

            public static class Binding {
                private String name;
                private String onBehalfOf = "currentUser";
                private Map<String, String> options = new HashMap<String, String>();

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public String getOnBehalfOf() {
                    return this.onBehalfOf;
                }

                @Generated
                public Map<String, String> getOptions() {
                    return this.options;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }

                @Generated
                public void setOnBehalfOf(String onBehalfOf) {
                    this.onBehalfOf = onBehalfOf;
                }

                @Generated
                public void setOptions(Map<String, String> options) {
                    this.options = options;
                }
            }

            public static class Rfc {
                private boolean transactionalByDefault = true;

                @Generated
                public boolean isTransactionalByDefault() {
                    return this.transactionalByDefault;
                }

                @Generated
                public void setTransactionalByDefault(boolean transactionalByDefault) {
                    this.transactionalByDefault = transactionalByDefault;
                }
            }
        }
    }

    public static class Locales {
        private Normalization normalization = new Normalization();

        @Generated
        public Normalization getNormalization() {
            return this.normalization;
        }

        @Generated
        public void setNormalization(Normalization normalization) {
            this.normalization = normalization;
        }

        public static class Normalization {
            private boolean defaults = true;
            private List<String> includeList = new ArrayList<String>();

            @Generated
            public boolean isDefaults() {
                return this.defaults;
            }

            @Generated
            public List<String> getIncludeList() {
                return this.includeList;
            }

            @Generated
            public void setDefaults(boolean defaults) {
                this.defaults = defaults;
            }

            @Generated
            public void setIncludeList(List<String> includeList) {
                this.includeList = includeList;
            }
        }
    }

    public static class Errors {
        private Enabled stackMessages = new Enabled(true);
        private Enabled defaultTranslations = new Enabled(true);
        private boolean extended = false;
        @Deprecated
        private boolean combined = true;
        private boolean preferServiceException = false;

        @Generated
        public Enabled getStackMessages() {
            return this.stackMessages;
        }

        @Generated
        public Enabled getDefaultTranslations() {
            return this.defaultTranslations;
        }

        @Generated
        public boolean isExtended() {
            return this.extended;
        }

        @Deprecated
        @Generated
        public boolean isCombined() {
            return this.combined;
        }

        @Generated
        public boolean isPreferServiceException() {
            return this.preferServiceException;
        }

        @Generated
        public void setStackMessages(Enabled stackMessages) {
            this.stackMessages = stackMessages;
        }

        @Generated
        public void setDefaultTranslations(Enabled defaultTranslations) {
            this.defaultTranslations = defaultTranslations;
        }

        @Generated
        public void setExtended(boolean extended) {
            this.extended = extended;
        }

        @Deprecated
        @Generated
        public void setCombined(boolean combined) {
            this.combined = combined;
        }

        @Generated
        public void setPreferServiceException(boolean preferServiceException) {
            this.preferServiceException = preferServiceException;
        }
    }

    public static class Drafts {
        private Duration cancellationTimeout = Duration.ofMinutes(15L);
        private Duration deletionTimeout = Duration.ofDays(30L);
        private String persistence = "joint";
        private boolean enforceReadonly;
        private GC gc = new GC();

        @Generated
        public Duration getCancellationTimeout() {
            return this.cancellationTimeout;
        }

        @Generated
        public Duration getDeletionTimeout() {
            return this.deletionTimeout;
        }

        @Generated
        public String getPersistence() {
            return this.persistence;
        }

        @Generated
        public boolean isEnforceReadonly() {
            return this.enforceReadonly;
        }

        @Generated
        public GC getGc() {
            return this.gc;
        }

        @Generated
        public void setCancellationTimeout(Duration cancellationTimeout) {
            this.cancellationTimeout = cancellationTimeout;
        }

        @Generated
        public void setDeletionTimeout(Duration deletionTimeout) {
            this.deletionTimeout = deletionTimeout;
        }

        @Generated
        public void setPersistence(String persistence) {
            this.persistence = persistence;
        }

        @Generated
        public void setEnforceReadonly(boolean enforceReadonly) {
            this.enforceReadonly = enforceReadonly;
        }

        @Generated
        public void setGc(GC gc) {
            this.gc = gc;
        }

        public static class GC
        extends Enabled {
            private Duration interval = Duration.ofHours(6L);
            private Duration maxPause = Duration.ofMinutes(5L);

            public GC() {
                super(true);
            }

            @Generated
            public Duration getInterval() {
                return this.interval;
            }

            @Generated
            public Duration getMaxPause() {
                return this.maxPause;
            }

            @Generated
            public void setInterval(Duration interval) {
                this.interval = interval;
            }

            @Generated
            public void setMaxPause(Duration maxPause) {
                this.maxPause = maxPause;
            }
        }
    }

    public static class Query {
        private Limit limit = new Limit();
        private Enabled implicitSorting = new Enabled(true);
        @DocumentedProperty(value=false)
        private Validation validation = new Validation();
        private Restrictions restrictions = new Restrictions();
        @DocumentedProperty(value=false)
        private Enabled deepEntityReadonly = new Enabled(false);

        @Generated
        public Limit getLimit() {
            return this.limit;
        }

        @Generated
        public Enabled getImplicitSorting() {
            return this.implicitSorting;
        }

        @Generated
        public Validation getValidation() {
            return this.validation;
        }

        @Generated
        public Restrictions getRestrictions() {
            return this.restrictions;
        }

        @Generated
        public Enabled getDeepEntityReadonly() {
            return this.deepEntityReadonly;
        }

        @Generated
        public void setLimit(Limit limit) {
            this.limit = limit;
        }

        @Generated
        public void setImplicitSorting(Enabled implicitSorting) {
            this.implicitSorting = implicitSorting;
        }

        @Generated
        public void setValidation(Validation validation) {
            this.validation = validation;
        }

        @Generated
        public void setRestrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
        }

        @Generated
        public void setDeepEntityReadonly(Enabled deepEntityReadonly) {
            this.deepEntityReadonly = deepEntityReadonly;
        }

        public static class Limit {
            private int _default = 0;
            private int max = 1000;
            private Enabled reliablePaging = new Enabled(false);

            public int getDefault() {
                return this._default;
            }

            public void setDefault(int _default) {
                this._default = _default;
            }

            @Generated
            public int getMax() {
                return this.max;
            }

            @Generated
            public void setMax(int max) {
                this.max = max;
            }

            @Generated
            public Enabled getReliablePaging() {
                return this.reliablePaging;
            }

            @Generated
            public void setReliablePaging(Enabled reliablePaging) {
                this.reliablePaging = reliablePaging;
            }
        }

        public static class Validation {
            private Enabled parameters = new Enabled(true);

            @Generated
            public Enabled getParameters() {
                return this.parameters;
            }

            @Generated
            public void setParameters(Enabled parameters) {
                this.parameters = parameters;
            }
        }

        public static class Restrictions
        extends Enabled {
            private Expand expand = new Expand();
            private Enabled filter = new Enabled(true);

            public Restrictions() {
                super(false);
            }

            @Generated
            public Expand getExpand() {
                return this.expand;
            }

            @Generated
            public Enabled getFilter() {
                return this.filter;
            }

            @Generated
            public void setExpand(Expand expand) {
                this.expand = expand;
            }

            @Generated
            public void setFilter(Enabled filter) {
                this.filter = filter;
            }

            public static class Expand
            extends Enabled {
                private int maxLevels = -1;

                public Expand() {
                    super(true);
                }

                @Generated
                public int getMaxLevels() {
                    return this.maxLevels;
                }

                @Generated
                public void setMaxLevels(int maxLevels) {
                    this.maxLevels = maxLevels;
                }
            }
        }
    }

    public static class Sql {
        private int maxBatchSize = 1000;
        @DocumentedProperty(value=false)
        private String collate = "strings";
        private Hana hana = new Hana();
        private InlineCount inlineCount = new InlineCount();
        @DocumentedProperty(value=false)
        private Search search = new Search();
        @DocumentedProperty(value=false)
        private RuntimeView runtimeView = new RuntimeView();
        @DocumentedProperty(value=false)
        private FilteredView filteredView = new FilteredView();
        private ToOnePath toOnePath = new ToOnePath();

        @Generated
        public int getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Generated
        public String getCollate() {
            return this.collate;
        }

        @Generated
        public Hana getHana() {
            return this.hana;
        }

        @Generated
        public InlineCount getInlineCount() {
            return this.inlineCount;
        }

        @Generated
        public Search getSearch() {
            return this.search;
        }

        @Generated
        public RuntimeView getRuntimeView() {
            return this.runtimeView;
        }

        @Generated
        public FilteredView getFilteredView() {
            return this.filteredView;
        }

        @Generated
        public ToOnePath getToOnePath() {
            return this.toOnePath;
        }

        @Generated
        public void setMaxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        @Generated
        public void setCollate(String collate) {
            this.collate = collate;
        }

        @Generated
        public void setHana(Hana hana) {
            this.hana = hana;
        }

        @Generated
        public void setInlineCount(InlineCount inlineCount) {
            this.inlineCount = inlineCount;
        }

        @Generated
        public void setSearch(Search search) {
            this.search = search;
        }

        @Generated
        public void setRuntimeView(RuntimeView runtimeView) {
            this.runtimeView = runtimeView;
        }

        @Generated
        public void setFilteredView(FilteredView filteredView) {
            this.filteredView = filteredView;
        }

        @Generated
        public void setToOnePath(ToOnePath toOnePath) {
            this.toOnePath = toOnePath;
        }

        public static class Hana {
            private boolean ignoreLocale = false;
            @Deprecated
            private String optimizationMode = "hex";
            @DocumentedProperty(value=false)
            private Enabled docstore = new Enabled(false);
            private Search search = new Search();

            @Generated
            public boolean isIgnoreLocale() {
                return this.ignoreLocale;
            }

            @Deprecated
            @Generated
            public String getOptimizationMode() {
                return this.optimizationMode;
            }

            @Generated
            public Enabled getDocstore() {
                return this.docstore;
            }

            @Generated
            public Search getSearch() {
                return this.search;
            }

            @Generated
            public void setIgnoreLocale(boolean ignoreLocale) {
                this.ignoreLocale = ignoreLocale;
            }

            @Deprecated
            @Generated
            public void setOptimizationMode(String optimizationMode) {
                this.optimizationMode = optimizationMode;
            }

            @Generated
            public void setDocstore(Enabled docstore) {
                this.docstore = docstore;
            }

            @Generated
            public void setSearch(Search search) {
                this.search = search;
            }

            public static class Search {
                private boolean fuzzy = false;
                private BigDecimal fuzzinessThreshold = new BigDecimal("0.8");

                @Generated
                public boolean isFuzzy() {
                    return this.fuzzy;
                }

                @Generated
                public BigDecimal getFuzzinessThreshold() {
                    return this.fuzzinessThreshold;
                }

                @Generated
                public void setFuzzy(boolean fuzzy) {
                    this.fuzzy = fuzzy;
                }

                @Generated
                public void setFuzzinessThreshold(BigDecimal fuzzinessThreshold) {
                    this.fuzzinessThreshold = fuzzinessThreshold;
                }
            }
        }

        public static class InlineCount {
            private String mode = "auto";

            @Generated
            public String getMode() {
                return this.mode;
            }

            @Generated
            public void setMode(String mode) {
                this.mode = mode;
            }
        }

        public static class Search {
            private String mode;

            @Generated
            public String getMode() {
                return this.mode;
            }

            @Generated
            public void setMode(String mode) {
                this.mode = mode;
            }
        }

        public static class RuntimeView {
            private String mode = "cte";

            @Generated
            public String getMode() {
                return this.mode;
            }

            @Generated
            public void setMode(String mode) {
                this.mode = mode;
            }
        }

        public static class FilteredView {
            private String mode = "view";

            @Generated
            public String getMode() {
                return this.mode;
            }

            @Generated
            public void setMode(String mode) {
                this.mode = mode;
            }
        }

        public static class ToOnePath {
            private String mode = "always-join";

            @Generated
            public String getMode() {
                return this.mode;
            }

            @Generated
            public void setMode(String mode) {
                this.mode = mode;
            }
        }
    }

    public static class AuditLog {
        private V2 v2 = new V2();
        private PersonalData personalData = new PersonalData();
        private Outbox outbox = new Outbox();
        @DocumentedProperty(value=false)
        private StandardEvents standardEvents = new StandardEvents();
        private ConnectionPool connectionPool = new ConnectionPool();

        @Generated
        public V2 getV2() {
            return this.v2;
        }

        @Generated
        public PersonalData getPersonalData() {
            return this.personalData;
        }

        @Generated
        public Outbox getOutbox() {
            return this.outbox;
        }

        @Generated
        public StandardEvents getStandardEvents() {
            return this.standardEvents;
        }

        @Generated
        public ConnectionPool getConnectionPool() {
            return this.connectionPool;
        }

        @Generated
        public void setV2(V2 v2) {
            this.v2 = v2;
        }

        @Generated
        public void setPersonalData(PersonalData personalData) {
            this.personalData = personalData;
        }

        @Generated
        public void setOutbox(Outbox outbox) {
            this.outbox = outbox;
        }

        @Generated
        public void setStandardEvents(StandardEvents standardEvents) {
            this.standardEvents = standardEvents;
        }

        @Generated
        public void setConnectionPool(ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
        }

        public static class V2
        extends Enabled {
            @DocumentedProperty(value=false)
            private boolean useLogonName = false;

            public V2() {
                super(true);
            }

            @Generated
            public boolean isUseLogonName() {
                return this.useLogonName;
            }

            @Generated
            public void setUseLogonName(boolean useLogonName) {
                this.useLogonName = useLogonName;
            }
        }

        public static class PersonalData
        extends Enabled {
            private boolean throwOnMissingDataSubject = true;
            private Enabled logRead = new Enabled(true);
            @DocumentedProperty(value=false)
            private Enabled logInsert = new Enabled(true);
            @DocumentedProperty(value=false)
            private Enabled logDelete = new Enabled(true);
            @DocumentedProperty(value=false)
            private Enabled logUpdate = new Enabled(true);

            public PersonalData() {
                super(true);
            }

            @Generated
            public boolean isThrowOnMissingDataSubject() {
                return this.throwOnMissingDataSubject;
            }

            @Generated
            public Enabled getLogRead() {
                return this.logRead;
            }

            @Generated
            public Enabled getLogInsert() {
                return this.logInsert;
            }

            @Generated
            public Enabled getLogDelete() {
                return this.logDelete;
            }

            @Generated
            public Enabled getLogUpdate() {
                return this.logUpdate;
            }

            @Generated
            public void setThrowOnMissingDataSubject(boolean throwOnMissingDataSubject) {
                this.throwOnMissingDataSubject = throwOnMissingDataSubject;
            }

            @Generated
            public void setLogRead(Enabled logRead) {
                this.logRead = logRead;
            }

            @Generated
            public void setLogInsert(Enabled logInsert) {
                this.logInsert = logInsert;
            }

            @Generated
            public void setLogDelete(Enabled logDelete) {
                this.logDelete = logDelete;
            }

            @Generated
            public void setLogUpdate(Enabled logUpdate) {
                this.logUpdate = logUpdate;
            }
        }

        public static class Outbox
        extends Enabled {
            private String name = "DefaultOutboxUnordered";

            public Outbox() {
                super(true);
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }
        }

        public static class StandardEvents
        extends Enabled {
            private Enabled tenantLifecycleEvents = new Enabled(false);
            private Enabled unauthorizedRequestEvent = new Enabled(true);

            public StandardEvents() {
                super(false);
            }

            @Generated
            public Enabled getTenantLifecycleEvents() {
                return this.tenantLifecycleEvents;
            }

            @Generated
            public Enabled getUnauthorizedRequestEvent() {
                return this.unauthorizedRequestEvent;
            }

            @Generated
            public void setTenantLifecycleEvents(Enabled tenantLifecycleEvents) {
                this.tenantLifecycleEvents = tenantLifecycleEvents;
            }

            @Generated
            public void setUnauthorizedRequestEvent(Enabled unauthorizedRequestEvent) {
                this.unauthorizedRequestEvent = unauthorizedRequestEvent;
            }
        }
    }

    public static class Outbox {
        private InMemory inMemory = new InMemory();
        private Persistent persistent = new Persistent(true);
        @DocumentedProperty(value=false)
        private Duration tenantsInfoRefreshInterval = Duration.ofMinutes(5L);
        @DocumentedProperty(value=false)
        private Enabled providerTenant = new Enabled(true);
        private Map<String, OutboxServiceConfig> services = new HashMap<String, OutboxServiceConfig>();

        public Map<String, OutboxServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public OutboxServiceConfig getService(String name) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getName(), name)).findFirst().orElse(new OutboxServiceConfig(name));
        }

        @Generated
        public InMemory getInMemory() {
            return this.inMemory;
        }

        @Generated
        public Persistent getPersistent() {
            return this.persistent;
        }

        @Generated
        public Duration getTenantsInfoRefreshInterval() {
            return this.tenantsInfoRefreshInterval;
        }

        @Generated
        public Enabled getProviderTenant() {
            return this.providerTenant;
        }

        @Generated
        public void setInMemory(InMemory inMemory) {
            this.inMemory = inMemory;
        }

        @Generated
        public void setPersistent(Persistent persistent) {
            this.persistent = persistent;
        }

        @Generated
        public void setTenantsInfoRefreshInterval(Duration tenantsInfoRefreshInterval) {
            this.tenantsInfoRefreshInterval = tenantsInfoRefreshInterval;
        }

        @Generated
        public void setProviderTenant(Enabled providerTenant) {
            this.providerTenant = providerTenant;
        }

        @Generated
        public void setServices(Map<String, OutboxServiceConfig> services) {
            this.services = services;
        }

        public static class InMemory
        extends Enabled {
            private boolean emitDuringChangeSetContext = false;

            public InMemory() {
                super(true);
            }

            @Generated
            public boolean isEmitDuringChangeSetContext() {
                return this.emitDuringChangeSetContext;
            }

            @Generated
            public void setEmitDuringChangeSetContext(boolean emitDuringChangeSetContext) {
                this.emitDuringChangeSetContext = emitDuringChangeSetContext;
            }
        }

        public static class Persistent
        extends Enabled {
            @DocumentedProperty(value=false)
            private Scheduler scheduler = new Scheduler();

            public Persistent(Boolean enabled) {
                super(enabled);
            }

            @Generated
            public Scheduler getScheduler() {
                return this.scheduler;
            }

            @Generated
            public void setScheduler(Scheduler scheduler) {
                this.scheduler = scheduler;
            }

            public static class Scheduler {
                private AllTenantsTask allTenantsTask = new AllTenantsTask();

                @Generated
                public AllTenantsTask getAllTenantsTask() {
                    return this.allTenantsTask;
                }

                @Generated
                public void setAllTenantsTask(AllTenantsTask allTenantsTask) {
                    this.allTenantsTask = allTenantsTask;
                }

                public static class AllTenantsTask
                extends Enabled {
                    private Duration interval = Duration.ofHours(2L);
                    private Duration executionSpreadTime = Duration.ofMinutes(15L);
                    private Duration executionStartDelay = Duration.ofSeconds(30L);

                    public AllTenantsTask() {
                        super(false);
                    }

                    @Generated
                    public Duration getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Duration getExecutionSpreadTime() {
                        return this.executionSpreadTime;
                    }

                    @Generated
                    public Duration getExecutionStartDelay() {
                        return this.executionStartDelay;
                    }

                    @Generated
                    public void setInterval(Duration interval) {
                        this.interval = interval;
                    }

                    @Generated
                    public void setExecutionSpreadTime(Duration executionSpreadTime) {
                        this.executionSpreadTime = executionSpreadTime;
                    }

                    @Generated
                    public void setExecutionStartDelay(Duration executionStartDelay) {
                        this.executionStartDelay = executionStartDelay;
                    }
                }
            }
        }

        public static class OutboxServiceConfig
        extends Enabled {
            private String name;
            private int maxAttempts = 10;
            @DocumentedProperty(value=false)
            private Duration emitTimeout = Duration.ofSeconds(10L);
            @DocumentedProperty(value=false)
            private int chunkSize = 10;
            @DocumentedProperty(value=false)
            private Duration maxPause = Duration.ofMinutes(10L);
            @DocumentedProperty(value=false)
            private Enabled triggerSchedule = new Enabled(true);
            @DocumentedProperty(value=false)
            private boolean startCollector = true;
            @Deprecated
            private Enabled storeLastError = new Enabled(true);
            private boolean ordered = true;
            private boolean observable = true;
            private boolean checkVersion = true;

            public OutboxServiceConfig(String name) {
                super(true);
                this.name = name;
            }

            public OutboxServiceConfig() {
                super(true);
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public int getMaxAttempts() {
                return this.maxAttempts;
            }

            @Generated
            public Duration getEmitTimeout() {
                return this.emitTimeout;
            }

            @Generated
            public int getChunkSize() {
                return this.chunkSize;
            }

            @Generated
            public Duration getMaxPause() {
                return this.maxPause;
            }

            @Generated
            public Enabled getTriggerSchedule() {
                return this.triggerSchedule;
            }

            @Generated
            public boolean isStartCollector() {
                return this.startCollector;
            }

            @Deprecated
            @Generated
            public Enabled getStoreLastError() {
                return this.storeLastError;
            }

            @Generated
            public boolean isOrdered() {
                return this.ordered;
            }

            @Generated
            public boolean isObservable() {
                return this.observable;
            }

            @Generated
            public boolean isCheckVersion() {
                return this.checkVersion;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setMaxAttempts(int maxAttempts) {
                this.maxAttempts = maxAttempts;
            }

            @Generated
            public void setEmitTimeout(Duration emitTimeout) {
                this.emitTimeout = emitTimeout;
            }

            @Generated
            public void setChunkSize(int chunkSize) {
                this.chunkSize = chunkSize;
            }

            @Generated
            public void setMaxPause(Duration maxPause) {
                this.maxPause = maxPause;
            }

            @Generated
            public void setTriggerSchedule(Enabled triggerSchedule) {
                this.triggerSchedule = triggerSchedule;
            }

            @Generated
            public void setStartCollector(boolean startCollector) {
                this.startCollector = startCollector;
            }

            @Deprecated
            @Generated
            public void setStoreLastError(Enabled storeLastError) {
                this.storeLastError = storeLastError;
            }

            @Generated
            public void setOrdered(boolean ordered) {
                this.ordered = ordered;
            }

            @Generated
            public void setObservable(boolean observable) {
                this.observable = observable;
            }

            @Generated
            public void setCheckVersion(boolean checkVersion) {
                this.checkVersion = checkVersion;
            }
        }
    }

    public static class TaskScheduler
    extends Enabled {
        @DocumentedProperty(value=false)
        private Duration lookupInterval = Duration.ofSeconds(30L);
        @DocumentedProperty(value=false)
        private int threadPoolSize = 2;

        public TaskScheduler() {
            super(false);
        }

        @Generated
        public Duration getLookupInterval() {
            return this.lookupInterval;
        }

        @Generated
        public int getThreadPoolSize() {
            return this.threadPoolSize;
        }

        @Generated
        public void setLookupInterval(Duration lookupInterval) {
            this.lookupInterval = lookupInterval;
        }

        @Generated
        public void setThreadPoolSize(int threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
        }
    }

    public static class CloudSdk {
        private Enabled executorDecorator = new Enabled(true);

        @Generated
        public Enabled getExecutorDecorator() {
            return this.executorDecorator;
        }

        @Generated
        public void setExecutorDecorator(Enabled executorDecorator) {
            this.executorDecorator = executorDecorator;
        }
    }

    public static class UnifiedCustomerLandscape {
        private Servlet endpoint = new Servlet("ucl/spii/v1/tenantMappings", true);
        private X509 x509 = new X509();
        @DocumentedProperty(value=false)
        private String destination;

        @Generated
        public Servlet getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public X509 getX509() {
            return this.x509;
        }

        @Generated
        public String getDestination() {
            return this.destination;
        }

        @Generated
        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setX509(X509 x509) {
            this.x509 = x509;
        }

        @Generated
        public void setDestination(String destination) {
            this.destination = destination;
        }

        public static class X509 {
            private String certIssuer = "";
            private String certSubject = "";

            @Generated
            public String getCertIssuer() {
                return this.certIssuer;
            }

            @Generated
            public String getCertSubject() {
                return this.certSubject;
            }

            @Generated
            public void setCertIssuer(String certIssuer) {
                this.certIssuer = certIssuer;
            }

            @Generated
            public void setCertSubject(String certSubject) {
                this.certSubject = certSubject;
            }
        }
    }

    public static class OpenResourceDiscovery {
        private Servlet endpoint = new Servlet("/.well-known/open-resource-discovery", true);
        private String ordPath = "ord/open-resource-discovery.json";
        private List<ORDLink> ordLinks = new ArrayList<ORDLink>();

        @Generated
        public Servlet getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public String getOrdPath() {
            return this.ordPath;
        }

        @Generated
        public List<ORDLink> getOrdLinks() {
            return this.ordLinks;
        }

        @Generated
        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setOrdPath(String ordPath) {
            this.ordPath = ordPath;
        }

        @Generated
        public void setOrdLinks(List<ORDLink> ordLinks) {
            this.ordLinks = ordLinks;
        }

        public static class ORDLink {
            private String name;
            private String link;

            public ORDLink() {
            }

            public ORDLink(String name, String link) {
                this.name = name;
                this.link = link;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getLink() {
                return this.link;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setLink(String link) {
                this.link = link;
            }
        }
    }

    public static class Dashboard {
        @DocumentedProperty(value=false)
        private Enabled authorization = new Enabled(true);

        @Generated
        public Enabled getAuthorization() {
            return this.authorization;
        }

        @Generated
        public void setAuthorization(Enabled authorization) {
            this.authorization = authorization;
        }
    }

    public static class ConnectionPool {
        private Integer maxConnections = 200;
        private Integer maxConnectionsPerRoute = 20;
        private Duration timeout = Duration.ofMillis(60000L);
        private Enabled combinePools = new Enabled(true);

        public ConnectionPool() {
        }

        public ConnectionPool(Duration timeout, Integer maxConnectionsPerRoute, Integer maxConnections) {
            this.timeout = timeout;
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
            this.maxConnections = maxConnections;
        }

        @Generated
        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        @Generated
        public Integer getMaxConnectionsPerRoute() {
            return this.maxConnectionsPerRoute;
        }

        @Generated
        public Duration getTimeout() {
            return this.timeout;
        }

        @Generated
        public Enabled getCombinePools() {
            return this.combinePools;
        }

        @Generated
        public void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        @Generated
        public void setMaxConnectionsPerRoute(Integer maxConnectionsPerRoute) {
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        }

        @Generated
        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        @Generated
        public void setCombinePools(Enabled combinePools) {
            this.combinePools = combinePools;
        }
    }

    public static class Enabled {
        private Boolean enabled;

        public Enabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Composite {
        private Map<String, CompositeServiceConfig> services = new HashMap<String, CompositeServiceConfig>();

        public Map<String, CompositeServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        @Generated
        public void setServices(Map<String, CompositeServiceConfig> services) {
            this.services = services;
        }

        public static class CompositeServiceConfig {
            private String name;
            private List<Route> routes = new ArrayList<Route>();

            public CompositeServiceConfig(String name) {
                this.name = name;
            }

            public CompositeServiceConfig() {
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public List<Route> getRoutes() {
                return this.routes;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setRoutes(List<Route> routes) {
                this.routes = routes;
            }

            public static class Route {
                private String service;
                private List<String> events = new ArrayList<String>();

                @Generated
                public String getService() {
                    return this.service;
                }

                @Generated
                public List<String> getEvents() {
                    return this.events;
                }

                @Generated
                public void setService(String service) {
                    this.service = service;
                }

                @Generated
                public void setEvents(List<String> events) {
                    this.events = events;
                }
            }
        }
    }
}

