/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl;

import java.util.stream.Stream;

import com.sap.cds.services.Service;
import com.sap.cds.services.handler.EventPredicate;
import com.sap.cds.services.handler.Handler;
import com.sap.cds.services.runtime.CdsRuntime;

public interface ServiceSPI extends Service {

	/**
	 * Makes the {@link CdsRuntime} known to the {@link Service}
	 * @param runtime the {@link CdsRuntime}
	 */
	void setCdsRuntime(CdsRuntime runtime);

	/**
	 * Returns the {@link CdsRuntime} this {@link Service} belongs to.
	 *
	 * @return	The {@link CdsRuntime} instance.
	 */
	CdsRuntime getCdsRuntime();

	/**
	 * An entity describing a handler registration for this service.
	 */
	public interface HandlerRegistration {
		/**
		 * @return	The {@link EventPredicate} describing the matching events and CDS entities
		 */
		EventPredicate getEventPredicate();

		/**
		 * @return	The handler
		 */
		Handler getHandler();

		/**
		 * @return	The order of the handler
		 */
		int getOrder();
	}

	/**
	 * Provides a {@link Stream} of {@link HandlerRegistration}s for the given {@link Phase}.
	 *
	 * @param phase	The phase the registrations refer to
	 * @return	The stream
	 */
	Stream<HandlerRegistration> registrations(Phase phase);
}
