/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.application;

import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.application.ApplicationProvidersPreparedEventContext;
import com.sap.cds.services.application.ApplicationStartedEventContext;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

public class ApplicationLifecycleServiceImpl extends ServiceDelegator implements ApplicationLifecycleService {

	public ApplicationLifecycleServiceImpl(String name) {
		super(name);
	}

	@Override
	public void applicationProviders(CdsRuntimeConfigurer configurer) {
		ApplicationProvidersPreparedEventContext context = ApplicationProvidersPreparedEventContext.create();
		context.setCdsRuntimeConfigurer(configurer);
		emit(context);
	}

	@Override
	public void applicationPrepared() {
		ApplicationPreparedEventContext context = ApplicationPreparedEventContext.create();
		emit(context);
	}

	@Override
	public void applicationStarted() {
		ApplicationStartedEventContext context = ApplicationStartedEventContext.create();
		emit(context);
	}

}
