/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.cds;

import com.sap.cds.Result;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.CdsUpsertEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.utils.OrderConstants;

@ServiceName(value = "*", type = ApplicationService.class)
public class ApplicationDefaultOnHandler implements EventHandler {

	/*
	 * CRUDQ by default forwards CQN statements to the PersistenceService
	 */

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	protected Result defaultRead(CdsReadEventContext context) {
		return CdsServiceUtils.getDefaultPersistenceService(context).run(context.getCqn(), context.getCqnNamedValues());
	}

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	protected Result defaultCreate(CdsCreateEventContext context) {
		return CdsServiceUtils.getDefaultPersistenceService(context).run(context.getCqn());
	}

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	protected Result defaultUpsert(CdsUpsertEventContext context) {
		return CdsServiceUtils.getDefaultPersistenceService(context).run(context.getCqn());
	}

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	protected Result defaultUpdate(CdsUpdateEventContext context) {
		return CdsServiceUtils.getDefaultPersistenceService(context).run(context.getCqn(), context.getCqnValueSets());
	}

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	protected Result defaultDelete(CdsDeleteEventContext context) {
		return CdsServiceUtils.getDefaultPersistenceService(context).run(context.getCqn(), context.getCqnValueSets());
	}

}
