/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.cds;

import com.sap.cds.feature.config.pojo.CdsProperties.Application.ApplicationServiceConfig;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.services.AbstractCdsService;

public class ApplicationServiceImpl extends AbstractCdsService implements ApplicationService {

	private final CdsService definition;

	public ApplicationServiceImpl(ApplicationServiceConfig config, CdsRuntime runtime) {
		super(config.getName(), runtime);
		String definitionName = config.getModel() != null ? config.getModel() : config.getName();
		this.definition = runtime.getCdsModel().getService(definitionName);
	}

	@Override
	public CdsService getDefinition() {
		return definition;
	}

}
