/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.cds;

import java.util.Map;

import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.persistence.NullElementValidator;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;

/**
 * Handler class to check mandatory elements
 * Mandatory elements are expected to be sent by the client
 * If mandatory elements are string based, empty strings are considered invalid as well
 */
@ServiceName(value = "*", type = ApplicationService.class)
public class MandatoryHandler extends NullElementValidator {

	@Override
	protected boolean check(CdsElement element) {
		boolean mandatory = CdsAnnotations.MANDATORY.getOrDefault(element);
		Map<?, ?> commonFieldControl = CdsAnnotations.COMMON_FIELDCONTROL.getOrDefault(element);
		return mandatory || (commonFieldControl != null && "Mandatory".equals(commonFieldControl.get("#")));
	}

	@Override
	protected boolean isNull(Object obj) {
		if(obj == null) {
			return true;
		} else if (obj instanceof String) {
			return StringUtils.isEmpty((String) obj);
		}
		return false;
	}

}
