package com.sap.cds.services.impl.composite;

import java.util.Objects;
import java.util.regex.Pattern;

public class CompositeUtils {

	/**
	 * Translates an event pattern to a regular expression.
	 * @param eventPattern the event pattern used by the composite service
	 *
	 * @return the regular expression {@link Pattern}
	 */
	public static Pattern getEventMatcherRegexp(String eventPattern) {
		Objects.requireNonNull(eventPattern, "eventPattern must not be null");
		String regex = eventPattern.trim()
				.replace("*","\\*")
				.replaceAll("/\\\\\\*\\\\\\*$", "/.*")
				.replaceAll("\\\\\\*\\s*/", "([^/]*)/")
				.replaceAll("\\\\\\*$", "([^/]*)");
		return Pattern.compile(regex);
	}
}
