/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.draft;

import java.util.List;

import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnLimit;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.utils.model.CdsModelUtils;

/**
 * A {@link CqnModifier} for expand and inline parts of the statement
 */
public class SelectListModifier implements CqnModifier {

	private final CdsEntity target;
	private final List<Boolean> followActiveAssociations;
	private final EventContext context;

	public SelectListModifier(CdsEntity target, List<Boolean> followActiveAssociations, EventContext context) {
		this.target = target;
		this.followActiveAssociations = followActiveAssociations; // NOSONAR
		this.context = context;
	}

	@Override
	public CqnSelectListItem expand(StructuredTypeRef ref, List<CqnSelectListItem> items,
			List<CqnSortSpecification> orderBy, CqnLimit limit) {
		StructuredTypeRef newRef = ExpressionVisitor.copy(ref, new ReferenceModifier(target, followActiveAssociations, true, context));
		CqnModifier columnModifier = new ColumnsModifier(CdsModelUtils.getRefTarget(newRef, target), context);
		return CqnModifier.super.expand(newRef, columnModifier.items(items), columnModifier.orderBy(orderBy), limit);
	}

	@Override
	public CqnSelectListItem inline(StructuredTypeRef ref, List<CqnSelectListItem> items) {
		StructuredTypeRef newRef = ExpressionVisitor.copy(ref, new ReferenceModifier(target, followActiveAssociations, true, context));
		CqnModifier columnModifier = new ColumnsModifier(CdsModelUtils.getRefTarget(newRef, target), context);
		return CqnModifier.super.inline(newRef, columnModifier.items(items));
	}

}
