/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.handlerregistry.resolver;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;

/**
 * Handles handler methods returning <code>void</code>
 */
public class VoidReturnResolver implements ReturnResolver {

	private static final VoidReturnResolver instance = new VoidReturnResolver();

	/**
	 * True, if the class is applicable for this resolver
	 * @param clazz the class
	 * @return true, if the class is equal to <code>void</code>
	 */
	public static VoidReturnResolver createIfApplicable(Class<?> clazz) {
		if (clazz == Void.TYPE) {
			return instance;
		}
		return null;
	}

	private VoidReturnResolver() {
		// hidden
	}

	@Override
	public void resolve(Object returnValue, EventContext context) {
		// nothing to resolve
	}

	@Override
	public void verifyOrThrow(HandlerDescriptor descriptor) {
		// nothing to verify
	}

}
