/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.messages;

import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;

import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.Message.Severity;
import com.sap.cds.services.messages.Messages;

public class MessagesImpl implements Messages {

	private ConcurrentLinkedQueue<Message> messages = new ConcurrentLinkedQueue<>();

	private final Locale locale; // optional

	public MessagesImpl(Locale locale) {
		this.locale = locale;
	}

	@Override
	public Message info(String messageOrKey, Object... args) {
		Message message = new MessageImpl(Severity.INFO, locale, messageOrKey, args);
		messages.add(message);
		return message;
	}

	@Override
	public Message success(String messageOrKey, Object... args) {
		Message message = new MessageImpl(Severity.SUCCESS, locale, messageOrKey, args);
		messages.add(message);
		return message;
	}

	@Override
	public Message warn(String messageOrKey, Object... args) {
		Message message = new MessageImpl(Severity.WARNING, locale, messageOrKey, args);
		messages.add(message);
		return message;
	}

	@Override
	public Message error(String messageOrKey, Object... args) {
		Message message = new MessageImpl(Severity.ERROR, locale, messageOrKey, args);
		messages.add(message);
		return message;
	}

	@Override
	public Stream<Message> stream() {
		return messages.stream();
	}

}
