package com.sap.cds.services.impl.messaging.composite;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.config.pojo.CdsProperties.Composite.CompositeServiceConfig;
import com.sap.cds.feature.config.pojo.CdsProperties.Composite.CompositeServiceConfig.Route;
import com.sap.cds.feature.config.pojo.CdsProperties.Messaging.MessagingRoute;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.impl.composite.CompositeService;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;

public class MessagingCompositeService extends CompositeService implements MessagingService {

	private static final ObjectMapper mapper = new ObjectMapper();

	public MessagingCompositeService(String name, List<MessagingRoute> routes, CdsRuntime runtime) {
		super(toCompositeConfig(name, routes), runtime);
	}

	@Override
	public void send(String topic, String message) {
		TopicMessageEventContext context = TopicMessageEventContext.create(topic);
		context.setData(message);

		emit(context);
	}

	@Override
	public void send(String topic, Map<String, Object> message) {
		send(topic, toJson(message));
	}

	private String toJson(Object object) {
		try {
			return mapper.writeValueAsString(object);
		} catch (JsonProcessingException e) {
			throw new ErrorStatusException(ErrorStatuses.SERVER_ERROR, e);
		}
	}

	private static CompositeServiceConfig toCompositeConfig(String name, List<MessagingRoute> mRoutes) {
		CompositeServiceConfig result = new CompositeServiceConfig();
		result.setName(name);

		List<Route> cRoutes = mRoutes.stream().map(mRoute -> {
			Route route = new Route();
			route.setService(mRoute.getService());
			route.setEvents(mRoute.getTopics());
			return route;
		}).collect(Collectors.toList());

		result.setRoutes(cRoutes);
		return result;
	}
}
