/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.messaging.message;

/**
 * The known message type
 */
public enum MessageType {
	/**
	 * CDS typed message
	 */
	CDS("cds"),

	/**
	 * S4Hana typed message
	 */
	S4HANA("s4hana");

	private String type;

	public String getType() {
		return type;
	}

	MessageType(String type) {
		this.type = type;
	}

	/**
	 * Provides the message type from the given string. If the given string is unknown
	 * {@code null} is returned.
	 *
	 * @param type the name of the message type
	 *
	 * @return the {@link MessageType} or <code>null</code> if unknown spec
	 */
	public static MessageType getByType(String type) {

		if (type != null) {
			if (type.equals(CDS.getType())) 	return CDS;
			if (type.equals(S4HANA.getType())) 	return S4HANA;
		}

		return null;
	}
}
