/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.messaging.message;

import java.util.Map;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * Describes the content of a S/4HANA structured message, received via the messaging adapter
 */
@EventName("*")
public interface S4HanaMessageEventContext extends EventContext {

	static S4HanaMessageEventContext create(String entity, String event) {
		return EventContext.create(event, entity).as(S4HanaMessageEventContext.class);
	}

	Long getEventTime();

	void setEventTime(long eventTime);

	String getCloudEventsVersion();

	void setCloudEventsVersion(String cloudEventsVersion);

	String getSchemaURL();

	void setSchemaURL(String schemaUrl);

	String getContentType();

	void setContentType(String contentType);

	String getSource();

	void setSource(String source);

	String getEventType();

	void setEventType(String eventType);

	String getEventID();

	void setEventID(String eventId);

	Map<String, Object> getData();

	void setData(Map<String, Object> data);
}
