/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.persistence;

import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.model.CdsAnnotations;

/**
 * Handler class to check not null elements.
 * Adding not null to an element leads to a database constraint check.
 * This handler is mainly there to improve the error message in case such an element is set to null
 */
@ServiceName(value = "*", type = PersistenceService.class)
public class NotNullHandler extends NullElementValidator {

	@Override
	protected boolean check(CdsElement element) {
		return element.isNotNull() && Boolean.TRUE.equals(CdsAnnotations.ASSERT_NOTNULL.getOrDefault(element));
	}

	@Override
	protected boolean isNull(Object obj) {
		return obj == null;
	}

}
