/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.persistence;

import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

public class PersistenceServiceConfiguration implements CdsRuntimeConfiguration {

	@Override
	public void eventHandlers(CdsRuntimeConfigurer configurer) {
		if(configurer.getCdsRuntime().getServiceCatalog().getServices(PersistenceService.class).count() > 0) {
			configurer.eventHandler(new GenerateUUIDHandler())
				.eventHandler(new ManagedAspectHandler())
				.eventHandler(new NotNullHandler())
				.eventHandler(new MessagingHandler())
				.eventHandler(new FieldLengthAssertionHandler())
				.eventHandler(new CsvInitializationHandler());
		}

	}

}
