/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.request;

import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.RequestContextAccessor;
import com.sap.cds.services.runtime.CdsRuntime;

public class RequestContextAccessorImpl implements RequestContextAccessor {

	@Override
	public boolean isActive() {
		return RequestContextImpl.getCurrentInternal() != null;
	}

	@Override
	public RequestContext getCurrent(CdsRuntime runtime) {
		return RequestContextImpl.getCurrentOrDefault(runtime);
	}

}
