/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.request;

import java.util.Objects;
import java.util.function.Function;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;

public class RequestContextHelper implements RequestContext {

	private final CdsRuntime runtime;

	RequestContextHelper(CdsRuntime runtime) {
		Objects.requireNonNull(runtime, "runtime must not be null");
		this.runtime = runtime;
	}

	@Override
	public CdsModel getModel() {
		return temporaryContext(r -> r.getModel());
	}

	@Override
	public ServiceCatalog getServiceCatalog() {
		return temporaryContext(r -> r.getServiceCatalog());
	}

	@Override
	public ParameterInfo getParameterInfo() {
		return temporaryContext(r -> r.getParameterInfo());
	}

	@Override
	public UserInfo getUserInfo() {
		return temporaryContext(r -> r.getUserInfo());
	}

	@Override
	public Messages getMessages() {
		return temporaryContext(r -> r.getMessages());
	}

	private <T> T temporaryContext(Function<RequestContext, T> function) {
		return runtime.requestContext().run((newContext) -> {
			return function.apply(newContext);
		});
	}


}
