/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.request;

import com.sap.cds.services.request.ModifiableUserInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.request.UserInfoFactory;

public class UserInfoFactoryImpl implements UserInfoFactory {

	@Override
	public ModifiableUserInfo create(UserInfo userInfo) {
		return new ModifiableUserInfoImpl (userInfo != null ? userInfo : anonymousUserInfo());
	}

	// unauthenticated anonymous user
	public static UserInfo anonymousUserInfo() {
		return ANONYMOUS_USER;
	}

	// the privileged user has access in privileged mode (no authorization checks)
	public static UserInfo privilegedUserInfo() {
		return PRIVILEGED_USER;
	}

	private static UserInfo ANONYMOUS_USER = new UserInfo() {

		@Override
		public String getName() {
			return "anonymous";
		}

		@Override
		public boolean isSystemUser() {
			return false;
		}

		@Override
		public boolean isAuthenticated() {
			return false; // anonymous
		}

	};

	private static UserInfo PRIVILEGED_USER = new UserInfo() {

		@Override
		public String getName() {
			return "privileged";
		}

		@Override
		public boolean isPrivileged() {
			return true;
		}

		// this user will not pass authorization due to following properties (but due to isPrivilegd == true):

		@Override
		public boolean hasRole(String role) {
			return true;
		}

		@Override
		public boolean isSystemUser() {
			return true;
		}

		@Override
		public boolean isAuthenticated() {
			return true;
		}

	};
}
