/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.utils;

import java.util.Iterator;

import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsEntity;

public abstract class PathAwareCqnModifier extends TargetAwareCqnModifier {

	protected final CqnAnalyzer analyzer;

	public PathAwareCqnModifier(CqnAnalyzer analyzer, CdsEntity target) {
		super(target);
		this.analyzer = analyzer;
	}

	@Override
	public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
		Iterator<ResolvedSegment> resolved = analyzer.analyze(ref).iterator();
		for(int i=0; resolved.hasNext(); ++i) {
			segment(ref.segments().get(i), resolved.next(), i, ref);
		}

		return ref;
	}

	protected abstract void segment(RefSegment segment, ResolvedSegment resolved, int position, StructuredTypeRef ref);

}
