/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.Service;
import com.sap.cds.services.impl.ServiceCatalogSPI;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCatalogImpl
implements ServiceCatalogSPI {
    private static final Logger logger = LoggerFactory.getLogger(ServiceCatalogImpl.class);
    private final Map<String, Service> registeredServices = new ConcurrentHashMap<String, Service>();

    @Override
    public void register(Service service) {
        Objects.requireNonNull(service, "service is required");
        String serviceName = service.getName();
        if (this.registeredServices.putIfAbsent(serviceName, service) != null) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.DUPLICATE_SERVICE, new Object[]{serviceName});
        }
        logger.info("Registered service {}", (Object)serviceName);
    }

    public Service getService(String name) {
        return this.registeredServices.get(name);
    }

    public <S extends Service> Stream<S> getServices(Class<S> serviceClass) {
        Objects.requireNonNull(serviceClass, "Class of the service is required");
        return this.registeredServices.values().stream().filter(s -> serviceClass.isInstance(s)).map(s -> s);
    }

    public <S extends Service> S getService(Class<S> serviceClass, String name) {
        Objects.requireNonNull(serviceClass, "Class of the service is required");
        Service service = this.getService(name);
        if (service != null && serviceClass.isInstance(service)) {
            return (S)service;
        }
        return null;
    }

    public Stream<Service> getServices() {
        return this.registeredServices.values().stream();
    }
}

