/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.authorization.ActionAccessEventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.authorization.CalcWhereConditionEventContext;
import com.sap.cds.services.authorization.EntityAccessEventContext;
import com.sap.cds.services.authorization.FunctionAccessEventContext;
import com.sap.cds.services.authorization.ServiceAccessEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.authorization.PredicateLookup;
import com.sap.cds.services.impl.authorization.RestrictionLookup;
import com.sap.cds.services.impl.authorization.RestrictionUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cds.services.utils.model.Privilege;
import com.sap.cds.services.utils.model.Restriction;
import java.util.List;
import java.util.stream.Collectors;

@ServiceName(value={"*"}, type={AuthorizationService.class})
public class AuthorizationDefaultOnHandler
implements EventHandler {
    private final TenantAwareCache<RestrictionLookup, CdsModel> restrictionLookupCache;
    private final TenantAwareCache<PredicateLookup, CdsModel> predicateLookupCache;

    AuthorizationDefaultOnHandler(CdsRuntime runtime) {
        this.restrictionLookupCache = TenantAwareCache.create(() -> new RestrictionLookup(), (CdsRuntime)runtime);
        this.predicateLookupCache = TenantAwareCache.create(() -> new PredicateLookup(), (CdsRuntime)runtime);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultHasServiceAccess(ServiceAccessEventContext context) {
        String event = context.getAccessEventName();
        String service = context.getAccessServiceName();
        boolean result = true;
        Restriction restriction = ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).retrieveServiceRestriction(context.getModel(), service);
        if (restriction != null) {
            result = RestrictionUtils.passesRestriction(restriction, context.getUserInfo(), event);
        }
        context.setResult(result);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultHasEntityAccess(EntityAccessEventContext context) {
        String event = context.getAccessEventName();
        String entityName = context.getAccessEntityName();
        boolean result = true;
        Restriction restriction = ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).retrieveEntityRestriction(context.getModel(), entityName);
        if (restriction != null) {
            result = RestrictionUtils.passesRestriction(restriction, context.getUserInfo(), event);
        }
        context.setResult(result);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultHasFunctionAccess(FunctionAccessEventContext context) {
        String functionName = context.getFunctionName();
        String entityName = context.getEntityName();
        boolean result = true;
        Restriction restriction = ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).lookupFunctionRestriction(context.getModel(), entityName, functionName);
        if (restriction != null) {
            result = RestrictionUtils.passesRestriction(restriction, context.getUserInfo(), Privilege.PredefinedGrant.ALL.toString());
        }
        context.setResult(result);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultHasActionAccess(ActionAccessEventContext context) {
        String actionName = context.getActionName();
        String entityName = context.getEntityName();
        boolean result = true;
        Restriction restriction = ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).lookupActionRestriction(context.getModel(), entityName, actionName);
        if (restriction != null) {
            result = RestrictionUtils.passesRestriction(restriction, context.getUserInfo(), Privilege.PredefinedGrant.ALL.toString());
        }
        context.setResult(result);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultCalcWhereCondition(CalcWhereConditionEventContext context) {
        Restriction restriction;
        String event = context.getEventName();
        String entityName = context.getEntityName();
        CqnPredicate result = null;
        if (!context.getUserInfo().isPrivileged() && (restriction = ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).retrieveEntityRestriction(context.getModel(), entityName)) != null) {
            List privileges = RestrictionUtils.passingPrivilegesOfRestriction(restriction, context.getUserInfo(), event).collect(Collectors.toList());
            for (Privilege privilege : privileges) {
                CqnPredicate cqnPredicate = null;
                if (!StringUtils.isEmpty((String)privilege.getCxnWhereCondition())) {
                    try {
                        cqnPredicate = ((PredicateLookup)this.predicateLookupCache.findOrCreate()).resolvePredicate(privilege.getCxnWhereCondition(), context.getUserInfo());
                    }
                    catch (Exception e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_WHERE_CONDITION, new Object[]{privilege.getCxnWhereCondition(), entityName, event, context.getUserInfo().getName(), e});
                    }
                } else if (!StringUtils.isEmpty((String)privilege.getWhereCondition())) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INCONSISTENT_WHERE_CONDITION, new Object[]{privilege.getWhereCondition(), entityName});
                }
                if (cqnPredicate == null) {
                    result = null;
                    break;
                }
                result = result != null ? CQL.or((CqnPredicate)result, (CqnPredicate)cqnPredicate) : cqnPredicate;
            }
        }
        context.setResult(result);
    }
}

