/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.model.CdsModelUtils;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class CapabilitiesHandler
implements EventHandler {
    @Before(event={"READ"})
    @HandlerOrder(value=-10800)
    public void checkCapabilityRead(EventContext context) {
        if (!CapabilitiesHandler.getCapabilities(context).isReadable()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_READABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @Before(event={"CREATE", "UPSERT"})
    @HandlerOrder(value=-10800)
    public void checkCapabilityCreate(EventContext context) {
        if (!CapabilitiesHandler.getCapabilities(context).isInsertable()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_INSERTABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @Before(event={"UPDATE", "UPSERT"})
    @HandlerOrder(value=-10800)
    public void checkCapabilityUpdate(EventContext context) {
        if (!CapabilitiesHandler.getCapabilities(context).isUpdatable()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_UPDATABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @Before(event={"DELETE"})
    @HandlerOrder(value=-10800)
    public void checkCapabilityDelete(EventContext context) {
        if (!CapabilitiesHandler.getCapabilities(context).isDeletable()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_DELETABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    public static Capabilities getCapabilities(EventContext context) {
        CdsEntity entity = context.getTarget();
        boolean autoexposed = (Boolean)CdsAnnotations.AUTOEXPOSED.getOrDefault((CdsAnnotatable)entity);
        boolean autoexpose = (Boolean)CdsAnnotations.AUTOEXPOSE.getOrDefault((CdsAnnotatable)entity);
        CqnStatement cqn = (CqnStatement)context.get("cqn");
        if (CapabilitiesHandler.isDirectlyReferenced(cqn, context.getModel()) && autoexposed && !DraftUtils.isDraftEnabled((CdsEntity)entity)) {
            if (autoexpose) {
                return new Capabilities(true, false, false, false);
            }
            return new Capabilities(false, false, false, false);
        }
        boolean readonly = (Boolean)CdsAnnotations.READONLY.getOrDefault((CdsAnnotatable)entity);
        if (readonly) {
            return new Capabilities(true, false, false, false);
        }
        boolean insertOnly = (Boolean)CdsAnnotations.INSERTONLY.getOrDefault((CdsAnnotatable)entity);
        if (insertOnly) {
            return new Capabilities(false, true, false, false);
        }
        boolean insertable = CapabilitiesHandler.defaultToTrue(CdsAnnotations.INSERTABLE.getOrDefault((CdsAnnotatable)entity));
        boolean updatable = CapabilitiesHandler.defaultToTrue(CdsAnnotations.UPDATABLE.getOrDefault((CdsAnnotatable)entity));
        boolean deletable = CapabilitiesHandler.defaultToTrue(CdsAnnotations.DELETABLE.getOrDefault((CdsAnnotatable)entity));
        return new Capabilities(true, insertable, updatable, deletable);
    }

    private static boolean defaultToTrue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return !((String)value).equalsIgnoreCase("false");
        }
        return true;
    }

    private static boolean isDirectlyReferenced(CqnStatement cqn, CdsModel model) {
        if (cqn.isSelect() && cqn.asSelect().from().isSelect()) {
            return CapabilitiesHandler.isDirectlyReferenced((CqnStatement)cqn.asSelect().from().asSelect(), model);
        }
        AnalysisResult entityPath = CdsModelUtils.getEntityPath((CqnStructuredTypeRef)cqn.ref(), (CdsModel)model);
        CdsEntity rootEntity = ((ResolvedSegment)entityPath.iterator().next()).entity();
        return rootEntity.getQualifiedName().equals(entityPath.targetEntity().getQualifiedName());
    }

    public static class Capabilities {
        private boolean readable;
        private boolean insertable;
        private boolean updatable;
        private boolean deletable;

        private Capabilities(boolean readable, boolean insertable, boolean updatable, boolean deletable) {
            this.readable = readable;
            this.insertable = insertable;
            this.updatable = updatable;
            this.deletable = deletable;
        }

        public boolean isReadable() {
            return this.readable;
        }

        public boolean isInsertable() {
            return this.insertable;
        }

        public boolean isUpdatable() {
            return this.updatable;
        }

        public boolean isDeletable() {
            return this.deletable;
        }
    }
}

