/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEnumType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Map;
import java.util.stream.Collectors;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class EnumAssertionHandler
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11100)
    public void runCheck(EventContext context) {
        CdsModelUtils.visitDeep(context.getTarget(), CdsServiceUtils.getEntities(context), (entity, data, parent) -> entity.elements().forEach(element -> {
            if (!element.getType().isEnum()) {
                return;
            }
            if (Boolean.FALSE.equals(CdsAnnotations.ASSERT_RANGE.getOrDefault((CdsAnnotatable)element))) {
                return;
            }
            for (Map elementMap : data) {
                Object elementValue = elementMap.get(element.getName());
                if (elementValue == null) continue;
                this.ensureValidEnum(elementValue, (CdsElement)element);
            }
        }));
    }

    private void ensureValidEnum(Object elementValue, CdsElement element) {
        CdsEnumType enumElement = (CdsEnumType)element.getType().as(CdsEnumType.class);
        if (!enumElement.hasValue(elementValue)) {
            String validEnumValues = enumElement.enumerals().values().stream().map(e -> e.value() + " (" + e.name() + ")").collect(Collectors.joining(", "));
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_ENUM, new Object[]{elementValue, element.getName(), validEnumValues});
        }
    }
}

