/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.CdsDataException;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsTypeUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class RangeAssertionHandler
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11100)
    public void runCheck(EventContext context) {
        CdsModelUtils.visitDeep(context.getTarget(), CdsServiceUtils.getEntities(context), (entity, data, parent) -> entity.elements().forEach(element -> {
            List rangeValues = CdsAnnotations.ASSERT_RANGE.getListOrValue((CdsAnnotatable)element, null);
            if (rangeValues == null) {
                return;
            }
            if (!(rangeValues instanceof List)) {
                return;
            }
            if (rangeValues.size() != 2) {
                return;
            }
            if (!this.isAllowedType(element.getType())) {
                return;
            }
            List<Comparable<Object>> rangeConvertedValues = this.getConvertedRange(rangeValues, (CdsElement)element, entity.getName());
            for (Map elementMap : data) {
                Object elementValue = elementMap.get(element.getName());
                if (elementValue == null) continue;
                this.ensureValidRange((Comparable)elementValue, rangeConvertedValues);
            }
        }));
    }

    private void ensureValidRange(Comparable<Object> elementValue, List<Comparable<Object>> rangeValues) {
        Comparable<Object> minValue = rangeValues.get(0);
        Comparable<Object> maxValue = rangeValues.get(1);
        if (elementValue.compareTo(maxValue) > 0 || elementValue.compareTo(minValue) < 0) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.VALUE_OUT_OF_RANGE, new Object[]{elementValue, minValue, maxValue});
        }
    }

    private List<Comparable<Object>> getConvertedRange(List<Object> rangeValues, CdsElement element, String entityName) {
        try {
            return rangeValues.stream().map(oValue -> (Comparable)CdsTypeUtils.parse((CdsBaseType)((CdsSimpleType)element.getType().as(CdsSimpleType.class)).getType(), (String)oValue.toString())).collect(Collectors.toList());
        }
        catch (CdsDataException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_ANNOTATION, new Object[]{CdsAnnotations.ASSERT_RANGE.toString(), element.getName(), entityName, e});
        }
    }

    private boolean isAllowedType(CdsType elementType) {
        if (!(elementType instanceof CdsSimpleType)) {
            return false;
        }
        switch (((CdsSimpleType)elementType.as(CdsSimpleType.class)).getType()) {
            case INTEGER: 
            case INTEGER64: 
            case DECIMAL: 
            case DECIMAL_FLOAT: 
            case DOUBLE: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                return true;
            }
        }
        return false;
    }
}

